package netmatch;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.border.EtchedBorder;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.util.*;
import java.util.List;

import cytoscape.*;
import cytoscape.data.CyAttributes;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import netmatch.qtool.QToolFrame;
import netmatch.qtool.IQueryRecipient;
import netmatch.algorithm.Common;
import netmatch.algorithm.netMatch;
import netmatch.algorithm.GraphLoader;

public class netMatchFrame extends JFrame implements ActionListener, WindowListener, IQueryRecipient {
  /*private static final String mac = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
  private static final String metal = "javax.swing.plaf.metal.MetalLookAndFeel";
  private static final String motif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
  private static final String gtk = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
  private static final String windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
  private String currentLookAndFeel = windows;*/
  //private JMenuItem menuWindows, menuMetal;

  private static final int HEIGHT = 550;
  private static final int WIDTH = 550;

  ImageIcon[] icons;
  ImageIcon[] structures;
  ImageIcon[] menu;
  private static final String aboutImage = "bannerImage.jpg";
  private static final String selgimp = "select_gimp.gif";
  private static final String selmove = "select_move.gif";
  private static final String nodegimp = "node.gif";
  private static final String loopgimp = "loop_gimp.gif";
  private static final String edgegimp = "edge_gimp.gif";
  private static final String pathgimp = "path_gimp.gif";
  private static final String zoomin = "zoomin_gimp.gif";
  private static final String zoomout = "zoomout_gimp.gif";
  private static final String bi_fan = "bi_fan.gif";
  private static final String bi_parallel = "bi_parallel.gif";
  private static final String feed_forward_loop = "feed_forward_loop.gif";
  private static final String three_chain = "three_chain.gif";
  private static final String nuovo = "new.gif";
  private static final String load = "load.gif";
  private static final String save = "save.gif";
  private static final String change = "change.gif";
  private static final String pass = "pass.gif";
  private static final String exit = "exit.gif";
  private static final String clear = "clear.gif";
  private static final String nuovo16 = "new16.gif";
  private static final String load16 = "load16.gif";
  private static final String save16 = "save16.gif";
  private static final String change16 = "change16.gif";
  private static final String pass16 = "pass16.gif";
  private static final String exit16 = "exit16.gif";
  private static final String clear16 = "clear16.gif";
  private static final String draw16 = "draw16.gif";
  private static final String about16 = "about16.gif";
  private static final String path = "images/";

  private JTextArea log;
  private JComboBox query;
  private JComboBox target;
  private JRadioButton labeled;
  private JRadioButton directed;
  private netMatchResultsDialog result;
  private JComboBox qea, tea, qna, tna;

  private QToolFrame qEditor;
  private boolean isEditorOpen;  // tracks if editor is open
  private boolean isQueryApproximate;
  private Vector qpaths;
  private HashMap queries;

  public netMatchFrame(String title) {
    getContentPane().setLayout(new BorderLayout());
    setTitle(title);
    addWindowListener(this);

    icons = new ImageIcon[9];
    icons[0] = createImageIcon(path + aboutImage);
    icons[1] = createImageIcon(path + selgimp);
    icons[2] = createImageIcon(path + selmove);
    icons[3] = createImageIcon(path + nodegimp);
    icons[4] = createImageIcon(path + loopgimp);
    icons[5] = createImageIcon(path + edgegimp);
    icons[6] = createImageIcon(path + pathgimp);
    icons[7] = createImageIcon(path + zoomin);
    icons[8] = createImageIcon(path + zoomout);
    structures = new ImageIcon[4];
    structures[0] = createImageIcon(path + three_chain);
    structures[1] = createImageIcon(path + feed_forward_loop);
    structures[2] = createImageIcon(path + bi_parallel);
    structures[3] = createImageIcon(path + bi_fan);
    menu = new ImageIcon[16];
    menu[0] = createImageIcon(path + nuovo);
    menu[1] = createImageIcon(path + load);
    menu[2] = createImageIcon(path + save);
    menu[3] = createImageIcon(path + change);
    menu[4] = createImageIcon(path + pass);
    menu[5] = createImageIcon(path + exit);
    menu[6] = createImageIcon(path + clear);
    menu[7] = createImageIcon(path + nuovo16);
    menu[8] = createImageIcon(path + load16);
    menu[9] = createImageIcon(path + save16);
    menu[10] = createImageIcon(path + change16);
    menu[11] = createImageIcon(path + pass16);
    menu[12] = createImageIcon(path + exit16);
    menu[13] = createImageIcon(path + clear16);
    menu[14] = createImageIcon(path + draw16);
    menu[15] = createImageIcon(path + about16);

    JPanel principale = new JPanel();
    principale.setLayout(new BorderLayout());
    principale.setPreferredSize(new Dimension(WIDTH, HEIGHT));
    JMenuBar menuBar = createMenuBar();
    principale.add(menuBar, BorderLayout.NORTH);

    // Panel Left
    JPanel panelLeft = new JPanel();
    panelLeft.setLayout(new BorderLayout());//(new GridLayout(3,1));
    panelLeft.setMinimumSize(new Dimension(180, 500));

    JPanel panel2 = new JPanel();
    panel2.setLayout(new GridLayout(2, 1));
    panel2.setBorder(new TitledBorder(new EtchedBorder(), "Graph Properties:", TitledBorder.ABOVE_BOTTOM, TitledBorder.DEFAULT_JUSTIFICATION, null, Color.BLACK));
    panelLeft.add(panel2, BorderLayout.NORTH);
    labeled = new JRadioButton("Labeled");
    labeled.setSelected(true);
    labeled.addActionListener(this);
    labeled.setToolTipText("If not checked, all nodes and edges are supposed unlabeled.");
    panel2.add(labeled);
    directed = new JRadioButton("Directed");
    directed.setSelected(true);
    directed.addActionListener(this);
    directed.setToolTipText("If not checked, all edges are supposed undirected.");
    panel2.add(directed);
    JPanel panel3 = new JPanel();
    GridLayout g = new GridLayout(3, 1);
    g.setVgap(5);
    panel3.setLayout(g);
    panel3.setBorder(new TitledBorder(new EtchedBorder(), "Options:", TitledBorder.ABOVE_BOTTOM, TitledBorder.DEFAULT_JUSTIFICATION, null, Color.BLACK));

    JButton choose = new JButton("Acquire Data");
    choose.addActionListener(this);
    choose.setToolTipText("Press this button to update queries and networks loaded in the cytoscape main window.");
    panel3.add(choose);
    JButton go = new JButton("Go");
    go.addActionListener(this);
    go.setToolTipText("Start matching.");
    panel3.add(go);
    panelLeft.add(panel3, BorderLayout.SOUTH);
    JButton reset = new JButton("Reset");
    reset.addActionListener(this);
    reset.setToolTipText("Reset queries and networks.");
    panel3.add(reset);
    JPanel panel4 = new JPanel();
    panel4.setLayout(new GridLayout(2, 1));
    panelLeft.add(panel4, BorderLayout.CENTER);

    JPanel panel4q = new JPanel(new GridLayout(6, 1));
    panel4q.setBorder(new TitledBorder(new EtchedBorder(), "Query Properties:", TitledBorder.ABOVE_BOTTOM, TitledBorder.DEFAULT_JUSTIFICATION, null, Color.BLACK));
    panel4q.setMinimumSize(new Dimension(180, 250));
    JLabel lab = new JLabel("Query:");
    panel4q.add(lab);
    query = new JComboBox();
    query.setEditable(false);
    query.setEnabled(false);
    query.setBorder(new EtchedBorder());
    query.addActionListener(this);
    query.setToolTipText("Select a query.");
    panel4q.add(query);
    JLabel lab3 = new JLabel("Query Node Attributes:");
    panel4q.add(lab3);
    qna = new JComboBox();
    qna.setMinimumSize(new Dimension(30, 100));
    qna.setMaximumSize(new Dimension(50, 700));
    qna.setEnabled(false);
    qna.setToolTipText("Select query node attributes. If \"" + Strings.DEFAULT_ATTRIBUTES + "\" is selected, nodes's names are the default attributes.");
    panel4q.add(qna);
    JLabel lab4 = new JLabel("Query Edge Attributes:");
    panel4q.add(lab4);
    qea = new JComboBox();
    qea.setMinimumSize(new Dimension(30, 100));
    qea.setMaximumSize(new Dimension(50, 700));
    qea.setEnabled(false);
    qea.setToolTipText("Select query edge attributes.");
    panel4q.add(qea);
    panel4.add(panel4q);

    JPanel panel4t = new JPanel(new GridLayout(6, 1));
    panel4t.setBorder(new TitledBorder(new EtchedBorder(), "Network Properties:", TitledBorder.ABOVE_BOTTOM, TitledBorder.DEFAULT_JUSTIFICATION, null, Color.BLACK));
    panel4t.setMinimumSize(new Dimension(180, 250));
    JLabel lab2 = new JLabel("Network:");
    panel4t.add(lab2);
    target = new JComboBox();
    target.setEditable(false);
    target.setEnabled(false);
    target.setBorder(new EtchedBorder());
    target.addActionListener(this);
    target.setToolTipText("Select a network.");
    panel4t.add(target);
    JLabel lab5 = new JLabel("Network Node Attributes:");
    panel4t.add(lab5);
    tna = new JComboBox();
    tna.setMinimumSize(new Dimension(30, 100));
    tna.setMaximumSize(new Dimension(50, 700));
    tna.setEnabled(false);
    tna.setToolTipText("Select network node attributes. If \"" + Strings.DEFAULT_ATTRIBUTES + "\" is selected, nodes's names are the default attributes.");
    panel4t.add(tna);
    JLabel lab6 = new JLabel("Network Edge Attributes:");
    panel4t.add(lab6);
    tea = new JComboBox();
    tea.setMinimumSize(new Dimension(30, 100));
    tea.setMaximumSize(new Dimension(50, 700));
    tea.setEnabled(false);
    tea.setToolTipText("Select network node attributes.");
    panel4t.add(tea);
    panel4.add(panel4t);

    // Panel Right
    JPanel panelRightUP = new JPanel();
    panelRightUP.setLayout(new BorderLayout());
    panelRightUP.setMinimumSize(new Dimension(180, 136));
    result = new netMatchResultsDialog();
    panelRightUP.add(result, BorderLayout.CENTER);

    JPanel panelRightDOWN = new JPanel();
    panelRightDOWN.setLayout(new BorderLayout());

    JPanel panelRight = new JPanel();
    panelRight.setLayout(new BorderLayout());

    JSplitPane splitPane2 = new JSplitPane(JSplitPane.VERTICAL_SPLIT, panelRightUP, panelRightDOWN);
    splitPane2.setOneTouchExpandable(true);
    splitPane2.setContinuousLayout(true);
    splitPane2.setDividerLocation(350);
    panelRight.add(splitPane2, BorderLayout.CENTER);

    log = new JTextArea();
    log.setEditable(false);
    log.setBackground(Color.WHITE);
    log.setBorder(new TitledBorder(new EtchedBorder(), "Log:", TitledBorder.ABOVE_BOTTOM, TitledBorder.DEFAULT_JUSTIFICATION, null, Color.BLACK));
    JScrollPane scroller = new JScrollPane();
    scroller.getViewport().add(log);
    panelRightDOWN.add(scroller, BorderLayout.CENTER);

    JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, panelLeft, panelRight);
    splitPane.setOneTouchExpandable(true);
    splitPane.setContinuousLayout(true);
    splitPane.setDividerLocation(200);
    principale.add(splitPane, BorderLayout.CENTER);
    getContentPane().add(principale, BorderLayout.CENTER);
    //updateLookAndFeel();
    queries = new HashMap();
    isEditorOpen = false;
    isQueryApproximate = false;
    qpaths = new Vector();
    if(!Cytoscape.getNetworkSet().isEmpty())
      acquireData();
  }

  private ImageIcon createImageIcon(String filename) {
    return new ImageIcon(getClass().getResource(filename));
  }

  public void windowClosing(WindowEvent e) {
    if(e.getSource() != this)
      return;
    Window window = e.getWindow();
    if(window.equals(this)) {
      if(isEditorOpen)
        qEditor.exit();
      setVisible(false);
      dispose();
    }
  }

  /*public void setNetworks(String queryName,String targetName) {
    query.setText(queryName);
    target.setText(targetName);
    CyNetwork q = Cytoscape.getNetwork(query.getText().substring(0,target.getText().indexOf('-')));
    String attrs[] = q.getEdgeAttributesList();
    for(int i = 0; i < attrs.length;i++)
      qea.addItem(attrs[i]);
    attrs = q.getNodeAttributesList();
    for(int i = 0; i < attrs.length;i++)
      qna.addItem(attrs[i]);
    CyNetwork t = Cytoscape.getNetwork(target.getText().substring(0,target.getText().indexOf('-')));
    attrs = q.getEdgeAttributesList();
    for(int i = 0; i < attrs.length;i++)
      tea.addItem(attrs[i]);
    attrs = q.getNodeAttributesList();
    for(int i = 0; i < attrs.length;i++)
      tna.addItem(attrs[i]);
    qea.setEnabled(true);
    qna.setEnabled(true);
    tea.setEnabled(true);
    tna.setEnabled(true);
  }*/


  public void windowActivated(WindowEvent e) {
  }

  public void windowDeactivated(WindowEvent e) {
  }

  public void windowDeiconified(WindowEvent e) {
  }

  public void windowClosed(WindowEvent e) {
  }

  public void windowIconified(WindowEvent e) {
  }

  public void windowOpened(WindowEvent e) {
  }

  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    Object o = e.getSource();
    /*if(command.equals("GTK"))
      setLookAndFeel(gtk);
    else if(command.equals("Windows"))
      setLookAndFeel(windows);
    else if(command.equals("Mac"))
      setLookAndFeel(mac);
    else if(command.equals("Motif"))
      setLookAndFeel(motif);
    else if(command.equals("Metal"))
      setLookAndFeel(metal);*/
    if(command.equals("Exit")) {
      processEvent(new WindowEvent(this, 201));
    }
    else if(command.equals("About...")) {
      JAboutDialog aboutbox = new JAboutDialog(this, icons[0]);
      aboutbox.setVisible(true);
    }
    else if(command.equals("Reset")) {
      log.setText("");
      query.removeActionListener(this);
      target.removeActionListener(this);
      query.removeAllItems();
      query.setEnabled(false);
      target.removeAllItems();
      target.setEnabled(false);
      qea.removeAllItems();
      qea.setEnabled(false);
      qna.removeAllItems();
      qna.setEnabled(false);
      tea.removeAllItems();
      tea.setEnabled(false);
      tna.removeAllItems();
      tna.setEnabled(false);
      result.clear();
      query.addActionListener(this);
      target.addActionListener(this);
      labeled.setSelected(true);
      directed.setSelected(true);
    }
    else if(command.equals("Draw...")) {
      if(!isEditorOpen) {
        qEditor = new QToolFrame("NetMatch Query Editor", this, icons, structures,menu);
        qEditor.setVisible(true);
        qEditor.setResizable(true);
        isEditorOpen = true;
      }
      else
        qEditor.toFront();
    }
    else if(command.equals("Acquire Data")) {
      Set s = Cytoscape.getNetworkSet();
      if(s.isEmpty())
        JOptionPane.showMessageDialog(this, "Please Load a Network and a Query First!", "NetMatch", JOptionPane.INFORMATION_MESSAGE);
      else
        acquireData();
    }
    else if(command.equals("Go")) {
      if(!query.isEnabled() || !target.isEnabled()) {
        JOptionPane.showMessageDialog(this, "Please Select a Network and a Query First!", "NetMatch", JOptionPane.INFORMATION_MESSAGE);
      }
      else if(!areValidAttributes()) {
        JOptionPane.showMessageDialog(this, "List and Map Attributes can't be used in Netmatch!", "NetMatch", JOptionPane.ERROR_MESSAGE);
      }
      else {
        String t = (String)target.getSelectedItem();
        String q = (String)query.getSelectedItem();
        boolean isUsingQE = false;
        CyNetwork tnetwork = Cytoscape.getNetwork(t.substring(0, t.indexOf('-')));
        String nn = q.substring(0, q.indexOf('-'));
        if(nn.equals("QE"))
          isUsingQE = true;
        CyNetwork qnetwork = null;
        if(!isUsingQE)
          qnetwork = Cytoscape.getNetwork(nn);
        if(tnetwork == null || (qnetwork == null && !isUsingQE))
          JOptionPane.showMessageDialog(this, "Please Select a Network and a Query First!", "NetMatch Error", JOptionPane.ERROR_MESSAGE);
        else {
          Common.LABELED = labeled.isSelected();
          Common.DIRECTED = directed.isSelected();
          Boolean isRunning = (Boolean)tnetwork.getClientData("NetMatch_running");
          if(isRunning != null && isRunning.booleanValue()) {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "NetMatch is already running on this network. Please wait for it to complete.");
            //return;
          }
          else {
            log.setText("Start Matching...\n");
            result.clear();
            tnetwork.putClientData("NetMatch_running", new Boolean(true));
            netMatch netmatch;
            JTaskConfig config = new JTaskConfig();
            config.displayCancelButton(true);
            config.displayStatus(true);
            if(!isUsingQE) {
              netmatch = new netMatch(this, tnetwork, (String)tea.getSelectedItem(), (String)tna.getSelectedItem(), qnetwork, (String)qea.getSelectedItem(), (String)qna.getSelectedItem());
              TaskManager.executeTask(netmatch, config);
              if(netmatch.isCompletedSuccessfully()) {
                ArrayList l2 = netmatch.getArrayDest();
                ArrayList l1 = netmatch.getArraySource();
                tnetwork.putClientData("NetMatch_running", new Boolean(false));
                if(!l2.isEmpty()) {
                  printMatch(l1, qnetwork, l2, tnetwork);
                  result.set(l2, tnetwork, netmatch.getImageList());
                }
                log.append("Found " + l2.size() + " matches!\r\n");
              }
              else
                log.setText("");
            }
            else {
              netmatch = new netMatch(this, tnetwork, (String)tea.getSelectedItem(), (String)tna.getSelectedItem(), (GraphLoader)queries.get(q.substring(q.indexOf('-') + 1, q.length())));
              TaskManager.executeTask(netmatch, config);
              if(netmatch.isCompletedSuccessfully()) {
                ArrayList l2 = netmatch.getArrayDest();
                ArrayList l1 = netmatch.getArraySource();
                tnetwork.putClientData("NetMatch_running", new Boolean(false));
                if(!l2.isEmpty()) {
                  System.out.println("L2 NOT EMPTY:"+l2.size());
                  //CODICE QUERY APPROSSIMATE
                  if(isQueryApproximate) {
                    System.out.println("APPROXIMATE");
                    ArrayList l3 = new ArrayList();
                    ArrayList l4 = new ArrayList();
                    //try {
                      for(int j = 0;j < l2.size();j++) {
                        int tmp1[] = (int[])l1.get(j);
                        int tmp2[] = (int[])l2.get(j);
                        int count = 0;
                        System.out.println("QPATHS:"+qpaths.size());
                        for(int i = 0;i < qpaths.size();i++) {
                          String p = (String)qpaths.elementAt(i);
                          String vals[] = p.split(",");
                          int tsource = tmp2[getIndexOf((int[])l1.get(j),Integer.parseInt(vals[0]))];
                          int tdest = tmp2[getIndexOf((int[])l1.get(j),Integer.parseInt(vals[1]))];
                          String tmp = vals[2].substring(1);
                          String condition = tmp.substring(0,1);
                          if(tmp.indexOf('=') != -1)
                            condition = tmp.substring(0,tmp.indexOf('=')+1);
                          if(bfs(tnetwork,tsource,tdest,condition,Integer.parseInt(tmp.substring(condition.length())),Common.DIRECTED))
                            count++;
                          else
                            break;
                        }
                        System.out.println("COUNT:"+count);
                        if(count == qpaths.size()) {
                          l3.add(tmp1);
                          l4.add(tmp2);
                        }
                      }
                    /*}
                    catch(Exception ex) {
                      JOptionPane.showMessageDialog(this, "Please check approximate condition  in query!", "NetMatch Error", JOptionPane.ERROR_MESSAGE);
                    }*/
                    if(!l4.isEmpty()) {
                      System.out.println("L4 not empty:"+l4.size());
                      printMatch(l3,l4,tnetwork);
                      result.set(l4,tnetwork,netmatch.getImageList());
                    }
                    log.append("Found " + l4.size() + " matches!\r\n");
                  }
                  else {
                    printMatch(l1,l2,tnetwork);
                    result.set(l2, tnetwork, netmatch.getImageList());
                  }
                }
                else
                  log.append("Found 0 matches!\r\n");
              }
              else
                log.setText("");
            }
          }
        }
      }
    }
    else if(o == query) {
      Object oldQea = qea.getSelectedItem();
      Object oldQna = qna.getSelectedItem();
      qea.removeAllItems();
      qna.removeAllItems();
      String qu = (String)query.getSelectedItem();
      String nn = qu.substring(0, qu.indexOf('-'));
      if(nn.equals("QE")) {
        qea.setEnabled(true);
        qna.setEnabled(true);
        qna.addItem(qu + " - Nodes Attributes");
        qea.addItem(qu + " - Edges Attributes");
        // DIM: NA and EA are shiped with GraphLoader
      }
      else {
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        String attrs[] = edgesAttributes.getAttributeNames();
        for(int i = 0;i < attrs.length;i++)
          qea.addItem(attrs[i]);
        attrs = nodesAttributes.getAttributeNames();
        for(int i = 0;i < attrs.length;i++)
          qna.addItem(attrs[i]);
        qna.addItem(Strings.DEFAULT_ATTRIBUTES);
        if(oldQea != null) {
          for(int i = 0;i < qea.getItemCount();i++) {
            Object o1 = qea.getItemAt(i);
            if(o1.equals(oldQea)) {
              qea.setSelectedItem(oldQea);
              break;
            }
          }
        }
        if(oldQna != null) {
          for(int i = 0;i < qna.getItemCount();i++) {
            Object o1 = qna.getItemAt(i);
            if(o1.equals(oldQna)) {
              qna.setSelectedItem(oldQna);
              break;
            }
          }
        }
      }
    }
    /*else if(o == target) {
      tea.removeAllItems();
      tna.removeAllItems();
      //String tu = (String)target.getSelectedItem();

      CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
      CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
      String attrs[] = edgesAttributes.getAttributeNames();

      //CyNetwork t = Cytoscape.getNetwork(tu.substring(0, tu.indexOf('-')));
      //String attrs[] = t.getEdgeAttributesList();
      for(int i = 0;i < attrs.length;i++)
        tea.addItem(attrs[i]);
      //attrs = t.getNodeAttributesList();

      attrs = nodesAttributes.getAttributeNames();

      for(int i = 0;i < attrs.length;i++)
        tna.addItem(attrs[i]);
    }*/
  }

  private int getIndexOf(int[] array,int val) {
    for(int i = 0; i < array.length;i++)
      if(array[i] == val)
        return i;
    return -1;
  }

  private boolean areValidAttributes() {
    CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
    CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
    if(nodesAttributes.getType((String)qna.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_LIST ||
            nodesAttributes.getType((String)tna.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_LIST ||
            nodesAttributes.getType((String)qna.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_MAP ||
            nodesAttributes.getType((String)tna.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_MAP)
      return false;
    if(edgesAttributes.getType((String)qea.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_LIST ||
            edgesAttributes.getType((String)tea.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_LIST ||
            edgesAttributes.getType((String)qea.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_MAP ||
            edgesAttributes.getType((String)tea.getSelectedItem()) == CyAttributes.TYPE_SIMPLE_MAP)
      return false;
    return true;
  }

  /*String t = (String)target.getSelectedItem();
  String q = (String)query.getSelectedItem();
  CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
  CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
  CyNetwork tnetwork = Cytoscape.getNetwork(t.substring(0, t.indexOf('-')));
  List tnodes = tnetwork.nodesList();
  List tedges = tnetwork.edgesList();
  String attrs[] = edgesAttributes.getAttributeNames();
  for(int i = 0; i < attrs.length;i++) {
    if(attrs[i].equals(qea.getSelectedItem()) || attrs[i].equals(tea.getSelectedItem())) {
      System.out.print("QUERY: "+attrs[i]+" ");
      if(edgesAttributes.getType(attrs[i]) == CyAttributes.TYPE_BOOLEAN)
        System.out.println("BOOLEAN");
      else if(edgesAttributes.getType(attrs[i]) == CyAttributes.TYPE_COMPLEX)
        System.out.println("COMPLEX");
      else if(edgesAttributes.getType(attrs[i]) == CyAttributes.TYPE_FLOATING)
        System.out.println("FLOATING");
      else if(edgesAttributes.getType(attrs[i]) == CyAttributes.TYPE_INTEGER)
        System.out.println("INTEGER");
      else if(edgesAttributes.getType(attrs[i]) == CyAttributes.TYPE_SIMPLE_LIST)
        System.out.println("LIST");
      else if(edgesAttributes.getType(attrs[i]) == CyAttributes.TYPE_STRING)
        System.out.println("string");
      else if(edgesAttributes.getType(attrs[i]) == CyAttributes.TYPE_UNDEFINED)
        System.out.println("undefined");
    }
  }
  System.out.println("\nNODES ASTTR");
  String attrs2[] = nodesAttributes.getAttributeNames();
  for(int i = 0; i < attrs2.length;i++) {
    if(attrs2[i].equals(qna.getSelectedItem()) || attrs2[i].equals(tna.getSelectedItem())) {
      System.out.print("TARGET: "+attrs2[i]+" ");
      if(nodesAttributes.getType(attrs2[i]) == CyAttributes.TYPE_BOOLEAN)
        System.out.println("BOOLEAN");
      else if(nodesAttributes.getType(attrs2[i]) == CyAttributes.TYPE_COMPLEX)
        System.out.println("COMPLEX");
      else if(nodesAttributes.getType(attrs2[i]) == CyAttributes.TYPE_FLOATING)
        System.out.println("FLOATING");
      else if(nodesAttributes.getType(attrs2[i]) == CyAttributes.TYPE_INTEGER)
        System.out.println("INTEGER");
      else if(nodesAttributes.getType(attrs2[i]) == CyAttributes.TYPE_SIMPLE_LIST)
        System.out.println("LIST");
      else if(nodesAttributes.getType(attrs2[i]) == CyAttributes.TYPE_STRING)
        System.out.println("string");
      else if(nodesAttributes.getType(attrs2[i]) == CyAttributes.TYPE_UNDEFINED)
        System.out.println("undefined");
    }
  }*/
  /*for(Iterator it = tnodes.iterator();it.hasNext();) {
    CyNode node = (CyNode)it.next();
    //nodesAttributes.getAttributeList();
    //if(nodesAttributes.).getStringAttribute(node.getIdentifier(),nodeAttr);

  }
  String nn = q.substring(0, q.indexOf('-'));
  if(!nn.equals("QE")) {
    CyNetwork qnetwork = Cytoscape.getNetwork(nn);
    List qnodes = qnetwork.nodesList();
    List qedges = qnetwork.edgesList();
  }*/

  private void acquireData() {
    query.removeActionListener(this);
    target.removeActionListener(this);

    Object oldQuery = query.getSelectedItem();
    Object oldTarget = target.getSelectedItem();
    Object oldQea = qea.getSelectedItem();
    Object oldQna = qna.getSelectedItem();
    Object oldTea = tea.getSelectedItem();
    Object oldTna = tna.getSelectedItem();

    query.removeAllItems();
    target.removeAllItems();
    qea.removeAllItems();
    qna.removeAllItems();
    tea.removeAllItems();
    tna.removeAllItems();
    Set s = Cytoscape.getNetworkSet();
    for(Iterator it = s.iterator();it.hasNext();) {
      CyNetwork n = (CyNetwork)it.next();
      query.addItem(n.getIdentifier() + "-" + n.getTitle());
      target.addItem(n.getIdentifier() + "-" + n.getTitle());
    }
    query.setEnabled(true);
    target.setEnabled(true);

    //-- DIM: add queries from editor
    Iterator it = queries.keySet().iterator();
    while(it.hasNext()) {
      Object o = "QE-" + it.next();
      query.addItem(o);
      qea.addItem(o + " - Edges Attributes");
      qna.addItem(o + " - Nodes Attributes");
    }
    if(!query.isEnabled() && !queries.isEmpty()) {
      query.setEnabled(true);
    }
    //--

    if(oldQuery != null) {
      for(int i = 0;i < query.getItemCount();i++) {
        Object o = query.getItemAt(i);
        if(o.equals(oldQuery)) {
          query.setSelectedItem(oldQuery);
          break;
        }
      }
    }

    if(oldTarget != null) {
      for(int i = 0;i < target.getItemCount();i++) {
        Object o = target.getItemAt(i);
        if(o.equals(oldTarget)) {
          target.setSelectedItem(oldTarget);
          break;
        }
      }
    }

    String qu = (String)query.getSelectedItem();
    String nn = qu.substring(0, qu.indexOf('-'));
    CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
    CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
    String attrs[] = edgesAttributes.getAttributeNames();
    if(!nn.equals("QE")) {
      //CyNetwork q = Cytoscape.getNetwork(nn);
      //String attrs[] = q.getEdgeAttributesList();
      for(int i = 0;i < attrs.length;i++)
        qea.addItem(attrs[i]);
      //attrs = q.getNodeAttributesList();
      attrs = nodesAttributes.getAttributeNames();
      qea.setEnabled(true);
      for(int i = 0;i < attrs.length;i++)
        qna.addItem(attrs[i]);
      qna.setEnabled(true);
    }
    //String tu = (String)target.getSelectedItem();
    //CyNetwork t = Cytoscape.getNetwork(nn);
    //attrs = t.getEdgeAttributesList();
    attrs = edgesAttributes.getAttributeNames();
    for(int i = 0;i < attrs.length;i++)
      tea.addItem(attrs[i]);
    tea.setEnabled(true);
    //attrs = t.getNodeAttributesList();
    attrs = nodesAttributes.getAttributeNames();
    for(int i = 0;i < attrs.length;i++)
      tna.addItem(attrs[i]);
    tna.setEnabled(true);

    if(query.getItemCount() > 0 && !nn.equals("QE"))
      qna.addItem(Strings.DEFAULT_ATTRIBUTES);
    if(target.getItemCount() > 0)
      tna.addItem(Strings.DEFAULT_ATTRIBUTES);
    if(oldQea != null) {
      for(int i = 0;i < qea.getItemCount();i++) {
        Object o = qea.getItemAt(i);
        if(o.equals(oldQea)) {
          qea.setSelectedItem(oldQea);
          break;
        }
      }
    }
    if(oldQna != null) {
      for(int i = 0;i < qna.getItemCount();i++) {
        Object o = qna.getItemAt(i);
        if(o.equals(oldQna)) {
          qna.setSelectedItem(oldQna);
          break;
        }
      }
    }
    if(oldTea != null) {
      for(int i = 0;i < tea.getItemCount();i++) {
        Object o = tea.getItemAt(i);
        if(o.equals(oldTea)) {
          tea.setSelectedItem(oldTea);
          break;
        }
      }
    }
    if(oldTna != null) {
      for(int i = 0;i < tna.getItemCount();i++) {
        Object o = tna.getItemAt(i);
        if(o.equals(oldTna)) {
          tna.setSelectedItem(oldTna);
          break;
        }
      }
    }
    query.addActionListener(this);
    target.addActionListener(this);
  }

  private JMenuBar createMenuBar() {
    JMenuBar menuBar = new JMenuBar();
    JMenuItem i;
    JMenu fileMenu = new JMenu("File");
    i = new JMenuItem("Exit",menu[12]);
    i.addActionListener(this);
    fileMenu.add(i);
    menuBar.add(fileMenu);
    //---- query menu ----------
    JMenu queryMenu = new JMenu("Query");
    i = new JMenuItem("Draw...",menu[14]);
    i.addActionListener(this);
    queryMenu.add(i);
    menuBar.add(queryMenu);
    //--------------------------
    /*JMenu laf = new JMenu("Look & Feel");
    ButtonGroup group = new ButtonGroup();
    i = new JRadioButtonMenuItem("GTK");
    i.addActionListener(this);
    i.setEnabled(isAvailableLookAndFeel(gtk));
    group.add(i);
    laf.add(i);
    i = new JRadioButtonMenuItem("Mac");
    i.addActionListener(this);
    i.setEnabled(isAvailableLookAndFeel(mac));
    group.add(i);
    laf.add(i);
    i = new JRadioButtonMenuItem("Metal");
    i.addActionListener(this);
    i.setEnabled(isAvailableLookAndFeel(metal));
    menuMetal = i;
    group.add(i);
    laf.add(i);
    i = new JRadioButtonMenuItem("Motif");
    i.addActionListener(this);
    i.setEnabled(isAvailableLookAndFeel(motif));
    group.add(i);
    laf.add(i);
    i = new JRadioButtonMenuItem("Windows");
    i.addActionListener(this);
    i.setEnabled(isAvailableLookAndFeel(windows));
    i.setSelected(true);
    menuWindows = i;
    group.add(i);
    laf.add(i);
    menuBar.add(laf);*/
    JMenu help = new JMenu("?");
    i = new JMenuItem("About...",menu[15]);
    i.addActionListener(this);
    help.add(i);
    menuBar.add(help);
    return menuBar;
  }

  private void printMatch(ArrayList s, CyNetwork q, ArrayList d, CyNetwork t) {
    for(int i = 0;i < s.size();i++) {
      int tmp1[] = (int[])s.get(i);
      int tmp2[] = (int[])d.get(i);
      log.append("************************** Match " + (i + 1) + "\n");
      for(int j = 0;j < tmp1.length;j++)
        log.append(q.getNode(tmp1[j]).getIdentifier() + " matches " + t.getNode(tmp2[j]).getIdentifier() + "\n");
    }
    log.append("**************************\n");
  }

  private void printMatch(ArrayList s, ArrayList d, CyNetwork t) {
    for(int i = 0;i < s.size();i++) {
      int tmp1[] = (int[])s.get(i);
      int tmp2[] = (int[])d.get(i);
      log.append("************************** Match " + (i + 1) + "\n");
      for(int j = 0;j < tmp1.length;j++)
        log.append(tmp1[j] + " matches " + t.getNode(tmp2[j]).getIdentifier() + "\n");
    }
    log.append("**************************\n");
  }

  /*private boolean isAvailableLookAndFeel(String laf) {
    try {
      Class lnfClass = Class.forName(laf);
      LookAndFeel newLAF = (LookAndFeel)(lnfClass.newInstance());
      return newLAF.isSupportedLookAndFeel();
    }
    catch(Exception e) {
      return false;
    }
  }

  private void setLookAndFeel(String laf) {
    if(currentLookAndFeel != laf) {
      currentLookAndFeel = laf;
      updateLookAndFeel();
    }
  }

  private void updateLookAndFeel() {
    try {
      UIManager.setLookAndFeel(currentLookAndFeel);
      SwingUtilities.updateComponentTreeUI(this);
      if(isEditorOpen)
        qEditor.updateLookAndFeel(currentLookAndFeel);
    }
    catch(Exception ex) {
      setLookAndFeel(metal);
      menuWindows.setSelected(false);
      menuMetal.setSelected(true);
    }
  }*/

  public void addQueryStructure(String name, GraphLoader g) {
    if(!queries.containsKey(name)) {
      query.addItem("QE-" + name);
      query.setEnabled(true);
    }
    queries.put(name, g);
  }

  public void deattachRecipient() {
    isEditorOpen = false;
  }

  public void setQueryApproximate(boolean value) {
    isQueryApproximate = value;
  }

  public void addQPath(String path) {
    qpaths.add(path);
  }

  public void clearPaths() {
    qpaths.removeAllElements();
  }

  private boolean bfs(CyNetwork tnetwork,int source, int dest,String condition, int number,boolean directed) {
    if (source == dest)
      return false;
    CyNode cySource = (CyNode) tnetwork.getNode(source);
    CyNode dumpNode = new CyNode(null,Integer.MAX_VALUE);
    //CyNode cyDest = (CyNode) tnetwork.getNode(dest);
    //System.out.println("INIZIO BFS:"+cySource.getIdentifier()+" "+cyDest.getIdentifier());
    //int[] indicesN = tnetwork.getNodeIndicesArray();
    //int[] visitedN = new int[indicesN.length];
    int[] indicesE = tnetwork.getEdgeIndicesArray();
    //int[] visitedE = new int[indicesE.length];
    //int pred[] = new int[indicesN.length];

    List queue = new ArrayList();
    queue.add(cySource);
    //int[] nodesLevel = new int[1];
    //nodesLevel[0] = tnetwork.getIndex(cySource);
    queue.add(dumpNode);
    int level = 0;
    while(!queue.isEmpty()) {
      if(!checkCondition2(condition,number,level+1,indicesE.length))
        break;
      //System.out.println("_______________________________________________level:"+level);
      CyNode n = (CyNode)queue.get(0);
      int v = tnetwork.getIndex(n);
      //setVisited(tnetwork,indicesN,visitedN,indicesE,visitedE,directed,nodesLevel);
      queue.remove(0);
      /*System.out.print("extract node:"+n.getIdentifier()+"\nQUEUE:[");
      for(int i = 0; i < queue.size(); i++) {
        System.out.print(((CyNode)queue.get(i)).getIdentifier()+" ");
      }
      System.out.println("]");*/
      if(n == dumpNode) {
        if(queue.isEmpty())
          break;
        level++;
        //nodesLevel = new int[queue.size()];
        //for(int i = 0; i < queue.size();i++)
        //  nodesLevel[i] = tnetwork.getIndex((CyNode)queue.get(i));
        queue.add(dumpNode);
        continue;
      }

      /*System.out.print("NODEs IN LEVEL:");
      for(int i = 0; i < nodesLevel.length; i++) {
        System.out.print(" "+tnetwork.getNode(nodesLevel[i]).getIdentifier());
      }
      System.out.println();*/

      int adjEdges[];
      if(directed)
        adjEdges = tnetwork.getAdjacentEdgeIndicesArray(v,false,false,true);
      else
        adjEdges = tnetwork.getAdjacentEdgeIndicesArray(v,false,true,true);
      //System.out.print(" adjacent nodes:");
      for(int i = 0; i < adjEdges.length; i++) {
        int node = tnetwork.getEdgeTargetIndex(adjEdges[i]);
        if(node == v)
          node = tnetwork.getEdgeSourceIndex(adjEdges[i]);
        //System.out.print(" "+tnetwork.getNode(node).getIdentifier());
        //if(!isVisited(indicesN,visitedN,node)) {
          if(node == dest && checkCondition(condition,number,level+1)) {
            //System.out.println("\ntrovato. Level:"+(level+1)+" number:"+number);
            //printpath(tnetwork,indicesN,pred,source,dest);
            return true;
          }
          //setEdgeVisited(indicesE,visitedE,adjEdges[i]);
          CyNode w = (CyNode)tnetwork.getNode(node);
          if(!queue.contains(w))
            queue.add(w);
          //setVisited(tnetwork,indicesN,visitedN,indicesE,visitedE,directed,nodesLevel);
          /*for(int g=0; g < indicesN.length;g++)
            if(indicesN[g] == node)
              pred[g] = v;
          */
        //}
        //else
        //  System.out.println(" IS VISITED: "+tnetwork.getNode(node).getIdentifier());
      }
      //System.out.println();
    }
    return false;
  }

  /*private void printpath(CyNetwork network,int[] indicesN,int[] pred,int s,int d) {
    System.out.print(" "+network.getNode(d).getIdentifier());
    while(s != d) {
      for(int i=0; i < indicesN.length;i++) {
        if(indicesN[i] == d) {
          System.out.print(" "+network.getNode(pred[i]).getIdentifier());
          d = pred[i];
          break;
        }
      }
    }
  }*/

  private void printpath(CyNetwork network,int[] indicesN,int[] pred,int s,int d) {
    for(int i=0; i < indicesN.length;i++) {
      System.out.print("pred di "+network.getNode(indicesN[i]).getIdentifier());
      if(pred[i] != 0)
        System.out.println(' '+network.getNode(pred[i]).getIdentifier());
      else
        System.out.println("");
    }
  }

  /*private boolean bfs(CyNetwork tnetwork,int source, int dest,String condition, int number,boolean directed) {
    if (source == dest)
      return false;
    CyNode cySource = (CyNode) tnetwork.getNode(source);
    CyNode dumpNode = new CyNode(null,Integer.MAX_VALUE);
    int[] indices = tnetwork.getNodeIndicesArray();
    int[] visited = new int[indices.length];
    List queue = new ArrayList();
    queue.add(cySource);
    queue.add(dumpNode);
    int level = 0;
    while(!queue.isEmpty()) {
      System.out.println("_______________________________________________level:"+level);
      CyNode n = (CyNode)queue.get(0);
      int v = tnetwork.getIndex(n);
      //int nv = root.getIndex(n);
      setVisited(indices,visited,v);
      queue.remove(0);
      System.out.print("extract node:"+n.getIdentifier()+"\nQUEUE:[");
      for(int i = 0; i < queue.size(); i++) {
        System.out.print(((CyNode)queue.get(i)).getIdentifier()+" ");
      }
      System.out.println("]");
      if(n == dumpNode) {
        if(queue.isEmpty())
          break;
        level++;
        queue.add(dumpNode);
        continue;
      }
      int adjEdges[];
      if(directed)
        adjEdges = tnetwork.getAdjacentEdgeIndicesArray(v,false,false,true);
      else
        adjEdges = tnetwork.getAdjacentEdgeIndicesArray(v,false,true,true);
      ArrayList adjNodes = new ArrayList();
      System.out.print(" adjacent nodes:");
      for(int i = 0; i < adjEdges.length; i++) {
        int node = tnetwork.getEdgeTargetIndex(adjEdges[i]);
        if(node == v)
          node = tnetwork.getEdgeSourceIndex(adjEdges[i]);
        System.out.print(" "+tnetwork.getNode(node).getIdentifier());
        if(!isVisited(indices,visited,node))
          adjNodes.add(new Integer(node));
        else
          System.out.println(" IS VISITED: "+tnetwork.getNode(node).getIdentifier());
      }
      System.out.println();
      for (int k = 0; k < adjNodes.size(); k++) {
        int nw = ((Integer)adjNodes.get(k)).intValue();
        if(nw == dest && checkCondition(condition,number,level+1)) {
          System.out.println("trovato");
          return true;
        }
        if(nw != dest) {
          CyNode w = (CyNode)tnetwork.getNode(nw);
          queue.add(w);
          setVisited(indices,visited,nw);
        }
      }
    }
    return false;
  }*/

  /*private boolean dfs(CyNetwork tnetwork,int source, int dest,String condition, int number,boolean directed) {
    if (source == dest)
      return false;
    CyNode cySource = (CyNode) tnetwork.getNode(source);
    int[] indices = tnetwork.getNodeIndicesArray();
    int[] visited = new int[indices.length];
    Stack stack = new Stack();
    stack.add(cySource);
    int level = 0;
    while(!stack.isEmpty()) {
      CyNode n = (CyNode)stack.pop();
      int v = tnetwork.getIndex(n);
      setVisited(indices,visited,v);
      int adjEdges[];
      if(directed)
        adjEdges = tnetwork.getAdjacentEdgeIndicesArray(v,false,false,true);
      else
        adjEdges = tnetwork.getAdjacentEdgeIndicesArray(v,false,true,true);
      ArrayList adjNodes = new ArrayList();
      for(int i = 0; i < adjEdges.length; i++) {
        int node = tnetwork.getEdgeTargetIndex(adjEdges[i]);
        if(node == v)
          node = tnetwork.getEdgeSourceIndex(adjEdges[i]);
        if(!isVisited(indices,visited,node)) {
          if(node == dest && checkCondition(condition,number,level+1))
            return true;
          CyNode w = (CyNode)tnetwork.getNode(node);
          stack.add(w);
          setVisited(indices,visited,node);

        }
      }
      for (int k = 0; k < adjNodes.size(); k++) {
        int nw = ((Integer)adjNodes.get(k)).intValue();
        if(nw == dest && checkCondition(condition,number,level+1))
          return true;
        CyNode w = (CyNode)tnetwork.getNode(nw);
        stack.add(w);
        setVisited(indices,visited,nw);
      }
    }
    return false;
  }*/
  /*void dfs_nr_visit(struct graph adj[],stacktype u) {
    struct node *t;
    int v;

    mark[u] = IN_STACK;
    push(&s,u);
    while(!stack_empty(s)) {
      u = pop(&s);
      list_insert_rear(&l,u);
      for(t=adj[u].succ;t;t=t->next) {
        v = t->vertex;
        if(mark[v] == UNVISITED) {
          push(&s,v);
          mark[v] = IN_STACK;
        }
      }
      mark[u] = VISITED;
    }
  }

  void nr_depthfirst_search(struct graph adj[]) {
    int u;

    for(u=0;adj[u].info;u++) {
      mark[u] = UNVISITED;
      pred[u] = -1;
      d[u] = 0;
      f[u] = 0;
    }
    time = 0;
    init_stack(&s);
    init_list(&l);
    for(u=0;adj[u].info;u++)
      if(mark[u] == UNVISITED)
        dfs_nr_visit(adj,u);
  }*/

  private void setVisited(CyNetwork network,int[] indicesN,int[] visitedN,int[] indicesE,int[] visitedE,boolean directed,int[] nodes) {
    int count = 0;
    int totEdges = 0;
    int[] adjEdges;
    for(int h = 0; h < nodes.length;h++) {
      /*if(directed)
        adjEdges = network.getAdjacentEdgeIndicesArray(nodes[h],false,false,true);
      else*/
        adjEdges = network.getAdjacentEdgeIndicesArray(nodes[h],false,true,true);
      totEdges += adjEdges.length;
      for(int j = 0; j < adjEdges.length;j++) {
        for(int k = 0; k < indicesE.length;k++) {
          if(adjEdges[j] == indicesE[k]) {
            if(visitedE[k] == 1)
              count++;
            break;
          }
        }
      }
    }
    if(totEdges == count) {
      //System.out.print("SET DEFINITIVE VISITED:");
      for(int hh = 0; hh < nodes.length;hh++) {
        for(int kk = 0; kk < indicesN.length;kk++) {
          if(indicesN[kk] == nodes[hh]) {
            System.out.print(" "+network.getNode(indicesN[kk]).getIdentifier());
            visitedN[kk] = 1;
            break;
          }
        }
      }
      System.out.println();
    }
  }


  private boolean isVisited(int[] indicesN, int[] visitedN,int node) {
    for(int i = 0; i < indicesN.length;i++) {
      if(indicesN[i] == node)
        return visitedN[i] == 1;
    }
    return false;
  }

  private void setEdgeVisited(int[] indicesE,int[] visitedE,int edge) {
    for(int i = 0; i < indicesE.length;i++) {
      if(indicesE[i] == edge) {
        visitedE[i] = 1;
        break;
      }
    }
  }

  /*private void setUnVisited(int[] indicesN, int[] visitedN,int node) {
    for(int i = 0; i < indicesN.length;i++) {
      if(indicesN[i] == node) {
        visitedN[i] = 0;
        break;
      }
    }
  }*/

  private boolean checkCondition(String cond,int number,int level) {
    //System.out.println("CONDITION:"+cond+" NUMBER:"+number+" LEVEL:"+level);
    if(cond.equals(Common.GT))
      return level > number;
    else if(cond.equals(Common.GE))
      return level >= number;
    else if(cond.equals(Common.EQ))
      return level == number;
    else if(cond.equals(Common.LT))
      return level < number;
    else if(cond.equals(Common.LE))
      return level <= number;
    return false;
  }

  private boolean checkCondition2(String cond,int number,int level,int num) {
    //System.out.println("CONDITION:"+cond+" NUMBER:"+number+" LEVEL:"+level);
    if(cond.equals(Common.GT) || cond.equals(Common.GE))
      return level < num;
    else if(cond.equals(Common.EQ) && level > number)
      return false;
    else if((cond.equals(Common.LT) || cond.equals(Common.LE)) && level > number)
      return false;
    return true;
  }

  /*private void setVisited(int[] indices, int[] visited,int node) {
    for(int i = 0; i < indices.length;i++) {
      if(indices[i] == node) {
        visited[i] = 1;
        break;
      }
    }
  }

  private boolean isVisited(int[] indices, int[] visited,int node) {
    for(int i = 0; i < indices.length;i++) {
      if(indices[i] == node)
        return visited[i] == 1;
    }
    return false;
  }

  private boolean checkCondition(String cond,int number,int level) {
    //System.out.println("CONDITION:"+cond+" NUMBER:"+number+" LEVEL:"+level);
    if(cond.equals(Common.GT))
      return level > number;
    else if(cond.equals(Common.GE))
      return level >= number;
    else if(cond.equals(Common.EQ))
      return level == number;
    else if(cond.equals(Common.LT))
      return level < number;
    else if(cond.equals(Common.LE))
      return level <= number;
    return false;
  }*/
}