package netmatch.algorithm;

public class Common {
  public static final String SELF_EDGE = "[SELFEDGE]";
  public static final String ANY_LABEL = "?";
  public static final int NULL_NODE = 0xFFFF;
  public static boolean DIRECTED = true;
  public static boolean LABELED = true;
  public static int imageSize = 80;
  public static final String APPROX_GT = "?>";
  public static final String APPROX_GE = "?>=";
  public static final String APPROX_EQ = "?=";
  public static final String APPROX_LT = "?<";
  public static final String APPROX_LE = "?<=";

  public static final String GT = ">";
  public static final String GE = ">=";
  public static final String EQ = "=";
  public static final String LT = "<";
  public static final String LE = "<=";

  public static boolean isApproximate(String s) {
    return s.startsWith(APPROX_GT) || s.startsWith(APPROX_GE) || s.startsWith(APPROX_EQ) || s.startsWith(APPROX_LT) || s.startsWith(APPROX_LE);
  }
}
