package netmatch;

import cytoscape.util.CytoscapeAction;
import cytoscape.visual.VisualMappingManager;
import cytoscape.Cytoscape;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelState;
import cytoscape.view.CytoscapeDesktop;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.net.URL;

public class netMatchPluginAction extends CytoscapeAction {
  private boolean opened = false;
  private netMatchPanel mainPanel;
  private VisualMappingManager vmm;

  public netMatchPluginAction() {
    super("NetMatch");
    vmm = Cytoscape.getVisualMappingManager();
  }

  public void actionPerformed(ActionEvent event) {
    CytoscapeDesktop desktop = Cytoscape.getDesktop();
    CytoPanel cytoPanel = desktop.getCytoPanel(SwingConstants.WEST);
    if (!opened) {
      mainPanel = new netMatchPanel(this);
      URL iconURL = netMatchPlugin.class.getResource("images/about16.gif");
      if (iconURL != null) {
        ImageIcon icon = new ImageIcon(iconURL);
        cytoPanel.add("", icon, mainPanel,"NetMatch");
      }
      else
        cytoPanel.add("NetMatch", mainPanel);
    }
    else
      JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "The NetMatch PlugIn is already running.");
    int index = cytoPanel.indexOfComponent(mainPanel);
    cytoPanel.setSelectedIndex(index);
    cytoPanel.setState(CytoPanelState.DOCK);
    setOpened(true);
  }

  public void setOpened(boolean opened) {
    this.opened = opened;
    if (!isOpened()) {
      vmm.setVisualStyle("default");
      vmm.applyAppearances();
    }
  }

  public boolean isOpened() {
    return opened;
  }
}