package netmatch.wizard;

import cytoscape.data.CyAttributes;
import cytoscape.Cytoscape;
import netmatch.Strings;
import netmatch.multipleAttrChoice;
import netmatch.netMatchPanel;

import javax.swing.*;
import java.util.ArrayList;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class WizardPanel2 extends JPanel implements ActionListener {
  private javax.swing.JComboBox edgeAttrCombo;
  private javax.swing.JComboBox nodeAttrCombo;
  private netMatchPanel panel;
  public WizardPanel2(netMatchPanel panel) {
    this.panel = panel;
    initComponents();
    acquireAttr();

  }

  public void acquireAttr() {
    nodeAttrCombo.removeActionListener(this);
    edgeAttrCombo.removeActionListener(this);
    nodeAttrCombo.removeAllItems();
    edgeAttrCombo.removeAllItems();
    CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
    CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
    String[] attrs = edgesAttributes.getAttributeNames();
    for(int i = 0;i < attrs.length;i++)
      edgeAttrCombo.addItem(attrs[i]);
    edgeAttrCombo.addItem(Strings.LIST_ATTRIBUTES);

    attrs = nodesAttributes.getAttributeNames();
    nodeAttrCombo.addItem(Strings.DEFAULT_ATTRIBUTES);
    for(int i = 0;i < attrs.length;i++)
      nodeAttrCombo.addItem(attrs[i]);
    nodeAttrCombo.addItem(Strings.LIST_ATTRIBUTES);
    nodeAttrCombo.addActionListener(this);
    edgeAttrCombo.addActionListener(this);
  }

  public void actionPerformed(ActionEvent e) {
    Object o = e.getSource();
    if(o == nodeAttrCombo) {
      if(((JComboBox)o).getSelectedItem().toString().equals(Strings.LIST_ATTRIBUTES) ||
         ((JComboBox)o).getSelectedItem().toString().equals(Strings.LIST_ATTRIBUTES_CHANGED)) {
        multipleAttrChoice m = new multipleAttrChoice(panel,"*Multiple Node Attributes",((JComboBox)o),true);
        m.setVisible(true);
      }
      else {
        ArrayList l = new ArrayList();
        l.add(nodeAttrCombo.getSelectedItem());
        panel.setAttrList(l,true);
      }
    }
    else if(o == edgeAttrCombo) {
      if(((JComboBox)o).getSelectedItem().toString().equals(Strings.LIST_ATTRIBUTES) ||
         ((JComboBox)o).getSelectedItem().toString().equals(Strings.LIST_ATTRIBUTES_CHANGED)) {
        multipleAttrChoice m = new multipleAttrChoice(panel,"*Multiple Edge Attributes",((JComboBox)o),false);
        m.setVisible(true);
      }
      else {
        ArrayList l = new ArrayList();
        l.add(edgeAttrCombo.getSelectedItem());
        panel.setAttrList(l,false);
      }
    }
  }

  public void setAttrList(ArrayList attrs,boolean isNodeAttr) {
    JComboBox c = isNodeAttr ? nodeAttrCombo: edgeAttrCombo;
    c.removeActionListener(this);
    if(attrs == null) {
      c.removeItem(Strings.LIST_ATTRIBUTES);
      c.removeItem(Strings.LIST_ATTRIBUTES_CHANGED);
      c.addItem(Strings.LIST_ATTRIBUTES);
      c.setSelectedIndex(0);
    }
    else {
      c.removeItem(Strings.LIST_ATTRIBUTES);
      c.removeItem(Strings.LIST_ATTRIBUTES_CHANGED);
      c.addItem(Strings.LIST_ATTRIBUTES_CHANGED);
      c.setSelectedItem(Strings.LIST_ATTRIBUTES_CHANGED);
    }
    c.addActionListener(this);
  }

  public boolean validateAndSave() {
    return true;
  }

  private void initComponents() {
    javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
    javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
    nodeAttrCombo = new javax.swing.JComboBox();
    javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
    edgeAttrCombo = new javax.swing.JComboBox();
    jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11));
    jLabel1.setText("Please select the attributes from following list: ");
    jLabel2.setText("Node attributes:");
    nodeAttrCombo.setModel(new javax.swing.DefaultComboBoxModel());
    jLabel3.setText("Edge attributes:");
    edgeAttrCombo.setModel(new javax.swing.DefaultComboBoxModel());
    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .add(18, 18, 18)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jLabel3)
                    .add(jLabel2)
                    .add(jLabel1)
                    .add(nodeAttrCombo, 0, 321, Short.MAX_VALUE)
                    .add(edgeAttrCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addContainerGap(61, Short.MAX_VALUE)));
    layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .addContainerGap()
            .add(jLabel1)
            .add(16, 16, 16)
            .add(jLabel2)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(nodeAttrCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(15, 15, 15)
            .add(jLabel3)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(edgeAttrCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addContainerGap(124, Short.MAX_VALUE)));
  }

  public String getNodeValue() {
    return (String)nodeAttrCombo.getSelectedItem();
  }

  public String getEdgeValue() {
    return (String)edgeAttrCombo.getSelectedItem();
  }
}
