// IMPORT FROM PICCOLOX

package netmatch.piccolox;

import edu.umd.cs.piccolo.PNode;

public class PBoundsLocator extends PNodeLocator {

  private int side;

  public static PBoundsLocator createEastLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 3);
  }

  public static PBoundsLocator createNorthEastLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 2);
  }

  public static PBoundsLocator createNorthWestLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 8);
  }

  public static PBoundsLocator createNorthLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 1);
  }

  public static PBoundsLocator createSouthLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 5);
  }

  public static PBoundsLocator createWestLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 7);
  }

  public static PBoundsLocator createSouthWestLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 6);
  }

  public static PBoundsLocator createSouthEastLocator(PNode pnode) {
    return new PBoundsLocator(pnode, 4);
  }

  public PBoundsLocator(PNode pnode, int i) {
    super(pnode);
    side = i;
  }

  public int getSide() {
    return side;
  }

  public void setSide(int i) {
    side = i;
  }

  public double locateX() {
    edu.umd.cs.piccolo.util.PBounds pbounds = node.getBoundsReference();
    switch(side) {
      case 6:// '\006'
      case 7:// '\007'
      case 8:// '\b'
        return pbounds.getX();

      case 2:// '\002'
      case 3:// '\003'
      case 4:// '\004'
        return pbounds.getX() + pbounds.getWidth();

      case 1:// '\001'
      case 5:// '\005'
        return pbounds.getX() + pbounds.getWidth() / 2D;
    }
    return -1D;
  }

  public double locateY() {
    edu.umd.cs.piccolo.util.PBounds pbounds = node.getBoundsReference();
    switch(side) {
      case 3:// '\003'
      case 7:// '\007'
        return pbounds.getY() + pbounds.getHeight() / 2D;

      case 4:// '\004'
      case 5:// '\005'
      case 6:// '\006'
        return pbounds.getY() + pbounds.getHeight();

      case 1:// '\001'
      case 2:// '\002'
      case 8:// '\b'
        return pbounds.getY();
    }
    return -1D;
  }
}