package netmatch.wizard;

import cytoscape.Cytoscape;
import cytoscape.CyNetwork;
import java.util.Iterator;
import java.util.Set;
import netmatch.qtool.QToolFrame;
import netmatch.netMatchPanel;

import javax.swing.*;


public class WizardPanel3 extends javax.swing.JPanel {
  private netMatchPanel f;
  private JComboBox queryCombo;
  private Set s;

  public WizardPanel3(netMatchPanel f) {
    this.f = f;
    initComponents();
  }

  public void acquireQueries() {
    s = Cytoscape.getNetworkSet();
    queryCombo.removeAllItems();
    for(Iterator it = s.iterator();it.hasNext();) {
      CyNetwork n = (CyNetwork)it.next();
      queryCombo.addItem(n.getIdentifier() + "-" + n.getTitle());
    }
    Iterator it = f.queries.keySet().iterator();
    while(it.hasNext()) {
      Object o = "QE-" + it.next();
      queryCombo.addItem(o);
    }
  }

  public boolean validateAndSave() {
    return !s.isEmpty();
  }

  public void selectQuery(String name) {
    queryCombo.setSelectedItem(name);
  }

  private void initComponents() {
    javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
    javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
    queryCombo = new javax.swing.JComboBox();
    javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
    javax.swing.JButton editorButton = new javax.swing.JButton();
    jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11));
    jLabel1.setText("Please select query network:");
    jLabel2.setText("Network loaded in Cytoscape workspace:");
    queryCombo.setModel(new javax.swing.DefaultComboBoxModel());

    jLabel3.setFont(new java.awt.Font("Tahoma", 1, 11));
    jLabel3.setText("Or draw one with Query Editor:");

    editorButton.setText("Lanch Editor");
    editorButton.setName("editorButton");
    editorButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        editorButtonActionPerformed(evt);
      }
    });

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .add(18, 18, 18)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel3)
                    .add(queryCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 336, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2)
                    .add(jLabel1)
                    .add(editorButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 161, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
            .addContainerGap(46, Short.MAX_VALUE)));
    layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .addContainerGap()
            .add(jLabel1)
            .add(15, 15, 15)
            .add(jLabel2)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(queryCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(22, 22, 22)
            .add(jLabel3)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(editorButton)
            .addContainerGap(119, Short.MAX_VALUE)));
  }

  private void editorButtonActionPerformed(java.awt.event.ActionEvent evt) {
    //if(!f.isEditorOpen()) {
      QToolFrame qEditor = new QToolFrame("NetMatch Query Editor",f, f.icons, f.structures, f.menu);
      qEditor.setVisible(true);
      qEditor.setResizable(true);
    //}
  }

  public String getValue() {
    return (String)queryCombo.getSelectedItem();
  }
}
