// IMPORTED FROM PICCOLOX

package netmatch.piccolox;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PBounds;

import java.awt.*;
import java.awt.geom.Rectangle2D;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;

public class PViewport extends JViewport {
  public static class PViewportLayout extends ViewportLayout {

    public void layoutContainer(Container container) {
      JViewport jviewport = (JViewport) container;
      Component component = jviewport.getView();
      if(component == null) {
      }
      else {
        Dimension dimension = jviewport.getSize();
        jviewport.setViewSize(dimension);
      }
    }

    public PViewportLayout() {
    }
  }


  PScrollDirector scrollDirector;

  public PViewport() {
    setScrollDirector(createScrollDirector());
  }

  protected LayoutManager createLayoutManager() {
    return new PViewportLayout();
  }

  protected PScrollDirector createScrollDirector() {
    return new PDefaultScrollDirector();
  }

  public void setScrollDirector(PScrollDirector pscrolldirector) {
    if(scrollDirector != null)
      scrollDirector.unInstall();
    scrollDirector = pscrolldirector;
    if(pscrolldirector != null)
      scrollDirector.install(this, (PCanvas) getView());
  }

  public PScrollDirector getScrollDirector() {
    return scrollDirector;
  }

  public void setView(Component component) {
    if(!(component instanceof PCanvas))
      throw new UnsupportedOperationException("PViewport only supports ZCanvas");
    super.setView(component);
    if(scrollDirector != null)
      scrollDirector.install(this, (PCanvas) component);
  }

  public void setViewPosition(Point point) {
    if(getView() == null)
      return;
    double d = 0.0D;
    double d1 = 0.0D;
    double d2 = point.x;
    double d3 = point.y;
    Point point1 = getViewPosition();
    if(point1 != null) {
      d = point1.getX();
      d1 = point1.getY();
    }
    double d4 = d2;
    double d5 = d3;
    if(d != d4 || d1 != d5) {
      scrollUnderway = true;
      scrollDirector.setViewPosition(d4, d5);
      fireStateChanged();
    }
  }

  public Point getViewPosition() {
    if(scrollDirector != null) {
      Dimension dimension = getExtentSize();
      return scrollDirector.getViewPosition(new PBounds(0.0D, 0.0D, dimension.getWidth(), dimension.getHeight()));
    }
    else {
      return null;
    }
  }

  public Dimension getViewSize() {
    Dimension dimension = getExtentSize();
    return scrollDirector.getViewSize(new PBounds(0.0D, 0.0D, dimension.getWidth(), dimension.getHeight()));
  }

  public Dimension getViewSize(Rectangle2D rectangle2d) {
    return scrollDirector.getViewSize(rectangle2d);
  }

  public void fireStateChanged() {
    super.fireStateChanged();
  }
}