// IMPORT FROM PICCOLOX

package netmatch.piccolox;

import edu.umd.cs.piccolo.*;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.*;

import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class PBoundsHandle extends PHandle {
  private PBasicInputEventHandler handleCursorHandler;

  public static void addBoundsHandlesTo(PNode pnode) {
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createEastLocator(pnode)));
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createWestLocator(pnode)));
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createNorthLocator(pnode)));
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createSouthLocator(pnode)));
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createNorthEastLocator(pnode)));
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createNorthWestLocator(pnode)));
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createSouthEastLocator(pnode)));
    pnode.addChild(new PBoundsHandle(PBoundsLocator.createSouthWestLocator(pnode)));
  }

  public static void addStickyBoundsHandlesTo(PNode pnode, PCamera pcamera) {
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createEastLocator(pnode)));
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createWestLocator(pnode)));
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createNorthLocator(pnode)));
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createSouthLocator(pnode)));
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createNorthEastLocator(pnode)));
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createNorthWestLocator(pnode)));
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createSouthEastLocator(pnode)));
    pcamera.addChild(new PBoundsHandle(PBoundsLocator.createSouthWestLocator(pnode)));
  }

  public static void removeBoundsHandlesFrom(PNode pnode) {
    ArrayList arraylist = new ArrayList();
    java.util.ListIterator listiterator = pnode.getChildrenIterator();
    do {
      if(!listiterator.hasNext())
        break;
      PNode pnode1 = (PNode) listiterator.next();
      if(pnode1 instanceof PBoundsHandle)
        arraylist.add(pnode1);
    }
    while(true);
    pnode.removeChildren(arraylist);
  }

  public PBoundsHandle(PBoundsLocator pboundslocator) {
    super(pboundslocator);
  }

  protected void installHandleEventHandlers() {
    super.installHandleEventHandlers();
    handleCursorHandler = new PBasicInputEventHandler() {

      boolean cursorPushed;

      public void mouseEntered(PInputEvent pinputevent) {
        if(!cursorPushed) {
          pinputevent.pushCursor(getCursorFor(((PBoundsLocator) getLocator()).getSide()));
          cursorPushed = true;
        }
      }

      public void mouseExited(PInputEvent pinputevent) {
        PPickPath ppickpath = pinputevent.getInputManager().getMouseFocus();
        if(cursorPushed && (ppickpath == null || ppickpath.getPickedNode() != PBoundsHandle.this)) {
          pinputevent.popCursor();
          cursorPushed = false;
        }
      }

      public void mouseReleased(PInputEvent pinputevent) {
        if(cursorPushed) {
          pinputevent.popCursor();
          cursorPushed = false;
        }
      }

      {
        cursorPushed = false;
      }
    };
    addInputEventListener(handleCursorHandler);
  }

  public PBasicInputEventHandler getHandleCursorEventHandler() {
    return handleCursorHandler;
  }

  public void startHandleDrag(Point2D point2d, PInputEvent pinputevent) {
    PBoundsLocator pboundslocator = (PBoundsLocator) getLocator();
    pboundslocator.getNode().startResizeBounds();
  }

  public void dragHandle(PDimension pdimension, PInputEvent pinputevent) {
    PBoundsLocator pboundslocator = (PBoundsLocator) getLocator();
    PNode pnode = pboundslocator.getNode();
    PBounds pbounds = pnode.getBounds();
    PNode pnode1 = getParent();
    if(pnode1 != pnode && (pnode1 instanceof PCamera))
      ((PCamera) pnode1).localToView(pdimension);
    localToGlobal(pdimension);
    pnode.globalToLocal(pdimension);
    double d = pdimension.getWidth();
    double d1 = pdimension.getHeight();
    switch(pboundslocator.getSide()) {
      case 1:// '\001'
        pbounds.setRect(pbounds.x, pbounds.y + d1, pbounds.width, pbounds.height - d1);
        break;

      case 5:// '\005'
        pbounds.setRect(pbounds.x, pbounds.y, pbounds.width, pbounds.height + d1);
        break;

      case 3:// '\003'
        pbounds.setRect(pbounds.x, pbounds.y, pbounds.width + d, pbounds.height);
        break;

      case 7:// '\007'
        pbounds.setRect(pbounds.x + d, pbounds.y, pbounds.width - d, pbounds.height);
        break;

      case 8:// '\b'
        pbounds.setRect(pbounds.x + d, pbounds.y + d1, pbounds.width - d, pbounds.height - d1);
        break;

      case 6:// '\006'
        pbounds.setRect(pbounds.x + d, pbounds.y, pbounds.width - d, pbounds.height + d1);
        break;

      case 2:// '\002'
        pbounds.setRect(pbounds.x, pbounds.y + d1, pbounds.width + d, pbounds.height - d1);
        break;

      case 4:// '\004'
        pbounds.setRect(pbounds.x, pbounds.y, pbounds.width + d, pbounds.height + d1);
        break;
    }
    boolean flag = false;
    boolean flag1 = false;
    if(pbounds.width < 0.0D) {
      flag = true;
      pbounds.width = -pbounds.width;
      pbounds.x -= pbounds.width;
    }
    if(pbounds.height < 0.0D) {
      flag1 = true;
      pbounds.height = -pbounds.height;
      pbounds.y -= pbounds.height;
    }
    if(flag || flag1)
      flipSiblingBoundsHandles(flag, flag1);
    pnode.setBounds(pbounds);
  }

  public void endHandleDrag(Point2D point2d, PInputEvent pinputevent) {
    PBoundsLocator pboundslocator = (PBoundsLocator) getLocator();
    pboundslocator.getNode().endResizeBounds();
  }

  public void flipSiblingBoundsHandles(boolean flag, boolean flag1) {
    java.util.ListIterator listiterator = getParent().getChildrenIterator();
    do {
      if(!listiterator.hasNext())
        break;
      Object obj = listiterator.next();
      if(obj instanceof PBoundsHandle)
        ((PBoundsHandle) obj).flipHandleIfNeeded(flag, flag1);
    }
    while(true);
  }

  public void flipHandleIfNeeded(boolean flag, boolean flag1) {
    PBoundsLocator pboundslocator = (PBoundsLocator) getLocator();
    if(flag || flag1)
      switch(pboundslocator.getSide()) {
        default:
          break;

        case 1:// '\001'
          if(flag1)
            pboundslocator.setSide(5);
          break;

        case 5:// '\005'
          if(flag1)
            pboundslocator.setSide(1);
          break;

        case 3:// '\003'
          if(flag)
            pboundslocator.setSide(7);
          break;

        case 7:// '\007'
          if(flag)
            pboundslocator.setSide(3);
          break;

        case 8:// '\b'
          if(flag && flag1) {
            pboundslocator.setSide(4);
            break;
          }
          if(flag) {
            pboundslocator.setSide(2);
            break;
          }
          if(flag1)
            pboundslocator.setSide(6);
          break;

        case 6:// '\006'
          if(flag && flag1) {
            pboundslocator.setSide(2);
            break;
          }
          if(flag) {
            pboundslocator.setSide(4);
            break;
          }
          if(flag1)
            pboundslocator.setSide(8);
          break;

        case 2:// '\002'
          if(flag && flag1) {
            pboundslocator.setSide(6);
            break;
          }
          if(flag) {
            pboundslocator.setSide(8);
            break;
          }
          if(flag1)
            pboundslocator.setSide(4);
          break;

        case 4:// '\004'
          if(flag && flag1) {
            pboundslocator.setSide(8);
            break;
          }
          if(flag) {
            pboundslocator.setSide(6);
            break;
          }
          if(flag1)
            pboundslocator.setSide(2);
          break;
      }
    setLocator(pboundslocator);
  }

  public Cursor getCursorFor(int i) {
    switch(i) {
      case 1:// '\001'
        return new Cursor(8);

      case 5:// '\005'
        return new Cursor(9);

      case 3:// '\003'
        return new Cursor(11);

      case 7:// '\007'
        return new Cursor(10);

      case 8:// '\b'
        return new Cursor(6);

      case 6:// '\006'
        return new Cursor(4);

      case 2:// '\002'
        return new Cursor(7);

      case 4:// '\004'
        return new Cursor(5);
    }
    return null;
  }
}