/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import giny.model.GraphPerspective;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import netmatch.algorithm.Common;
import netmatch.algorithm.Graph;
import netmatch.algorithm.GraphLoader;
import netmatch.algorithm.VF2MonoState;
import netmatch.algorithm.approxEdgeComparator;
import netmatch.algorithm.approxNodeComparator;
import netmatch.algorithm.exactEdgeComparator;
import netmatch.algorithm.exactNodeComparator;
import netmatch.algorithm.myInteger;
import netmatch.algorithm.myMatch;
import phoebe.PGraphView;

public class netMatch
implements Task {
    private String DBName;
    private String queryName;
    private JFrame frame;
    private CyNetwork target;
    private CyNetwork query;
    private TaskMonitor taskMonitor;
    private boolean interrupted;
    private boolean completedSuccessfully;
    private ArrayList array;
    private ArrayList source;
    private Image[] imageList;
    private String tea;
    private String tna;
    private String qea;
    private String qna;
    private GraphLoader qeLoader;
    private boolean isUsedEditor = false;

    public netMatch(String DBName, String queryName) {
        this.DBName = DBName;
        this.queryName = queryName;
        this.frame = null;
        this.target = null;
        this.query = null;
        this.taskMonitor = null;
        this.interrupted = false;
        this.completedSuccessfully = false;
        this.array = null;
        this.source = null;
        this.imageList = null;
        this.tea = null;
        this.tna = null;
        this.qea = null;
        this.qna = null;
    }

    public netMatch(JFrame frame, CyNetwork target, String tea, String tna, CyNetwork query, String qea, String qna) {
        this.DBName = null;
        this.queryName = null;
        this.frame = frame;
        this.target = target;
        this.query = query;
        this.tea = tea;
        this.tna = tna;
        this.qea = qea;
        this.qna = qna;
        this.taskMonitor = null;
        this.interrupted = false;
        this.completedSuccessfully = false;
        this.array = null;
        this.imageList = null;
        this.source = null;
    }

    public netMatch(JFrame frame, CyNetwork target, String tea, String tna, GraphLoader gl) {
        this.DBName = null;
        this.queryName = null;
        this.frame = frame;
        this.target = target;
        this.tea = tea;
        this.tna = tna;
        this.qeLoader = gl;
        this.isUsedEditor = true;
        this.taskMonitor = null;
        this.interrupted = false;
        this.completedSuccessfully = false;
        this.array = null;
        this.imageList = null;
        this.source = null;
    }

    public GraphLoader loadGraphFromNetwork(CyNetwork network, String edgeAttr, String nodeAttr) throws Exception {
        Hashtable<String, Integer> names = new Hashtable<String, Integer>();
        int k = 0;
        int i = 0;
        GraphLoader loader = new GraphLoader(this.frame);
        List nodes = network.nodesList();
        List edges = network.edgesList();
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        int size = nodes.size() + edges.size();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            CyNode node = (CyNode)it.next();
            String name1 = node.getIdentifier();
            String name1Attr = this.getAttribute(nodesAttributes, node.getIdentifier(), nodeAttr);
            if (!names.containsKey(name1)) {
                names.put(name1, new Integer(i++));
                loader.InsertNode(name1Attr, node.getRootGraphIndex());
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        it = edges.iterator();
        while (it.hasNext()) {
            CyEdge edge = (CyEdge)it.next();
            String type = this.getAttribute(edgesAttributes, edge.getIdentifier(), edgeAttr);
            CyNode source = (CyNode)edge.getSource();
            CyNode dest = (CyNode)edge.getTarget();
            String name1 = source.getIdentifier();
            String name2 = dest.getIdentifier();
            String name1Attr = this.getAttribute(nodesAttributes, source.getIdentifier(), nodeAttr);
            String name2Attr = this.getAttribute(nodesAttributes, dest.getIdentifier(), nodeAttr);
            boolean any = false;
            if (name1.equals(name2)) {
                name2 = name2 + "[SELFEDGE]";
                name2Attr = name2Attr + "[SELFEDGE]";
                if (!names.containsKey(name2)) {
                    names.put(name2, new Integer(i++));
                    loader.InsertNode(name2Attr, source.getRootGraphIndex());
                }
                any = true;
            }
            if (any) {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), type + "[SELFEDGE]");
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), type + "[SELFEDGE]");
                }
            } else {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), type);
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), type);
                }
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        return loader;
    }

    public GraphLoader loadGraphFromNetwork(CyNetwork network, String edgeAttr) throws Exception {
        Hashtable<String, Integer> names = new Hashtable<String, Integer>();
        int k = 0;
        int i = 0;
        GraphLoader loader = new GraphLoader(this.frame);
        List nodes = network.nodesList();
        List edges = network.edgesList();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        int size = nodes.size() + edges.size();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            CyNode node = (CyNode)it.next();
            String name1 = node.getIdentifier();
            if (!names.containsKey(name1)) {
                names.put(name1, new Integer(i++));
                loader.InsertNode(name1, node.getRootGraphIndex());
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        it = edges.iterator();
        while (it.hasNext()) {
            CyEdge edge = (CyEdge)it.next();
            String type = this.getAttribute(edgesAttributes, edge.getIdentifier(), edgeAttr);
            CyNode source = (CyNode)edge.getSource();
            CyNode dest = (CyNode)edge.getTarget();
            String name1 = source.getIdentifier();
            String name2 = dest.getIdentifier();
            boolean any = false;
            if (name1.equals(name2)) {
                if (!names.containsKey(name2 = name2 + "[SELFEDGE]")) {
                    names.put(name2, new Integer(i++));
                    loader.InsertNode(name2, source.getRootGraphIndex());
                }
                any = true;
            }
            if (any) {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), type + "[SELFEDGE]");
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), type + "[SELFEDGE]");
                }
            } else {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), type);
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), type);
                }
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        return loader;
    }

    private String getAttribute(CyAttributes attributes, String id, String attr) {
        String type = "UNDEFINED";
        if (attributes != null) {
            if (attributes.getType(attr) == 4) {
                type = attributes.getStringAttribute(id, attr);
            } else if (attributes.getType(attr) == 1) {
                type = attributes.getBooleanAttribute(id, attr).toString();
            } else if (attributes.getType(attr) == 2) {
                type = attributes.getDoubleAttribute(id, attr).toString();
            } else if (attributes.getType(attr) == 3) {
                type = attributes.getIntegerAttribute(id, attr).toString();
            }
        }
        return type;
    }

    public boolean isCompletedSuccessfully() {
        return this.completedSuccessfully;
    }

    public String getTitle() {
        return "NetMatch";
    }

    public void run() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        try {
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Create Network Loader (Step 1 of 5)");
            GraphLoader dbLoader = this.tna.equals("Default Names Attributes") ? this.loadGraphFromNetwork(this.target, this.tea) : this.loadGraphFromNetwork(this.target, this.tea, this.tna);
            if (this.checkTask()) {
                return;
            }
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Create Network Graph Data (Step 2 of 5)");
            Graph db = new Graph(dbLoader, this);
            if (this.checkTask()) {
                return;
            }
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Create Query Loader (Step 3 of 5)");
            GraphLoader qLoader = this.isUsedEditor ? this.qeLoader : (this.qna.equals("Default Names Attributes") ? this.loadGraphFromNetwork(this.query, this.qea) : this.loadGraphFromNetwork(this.query, this.qea, this.qna));
            if (this.checkTask()) {
                return;
            }
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Create Query Graph Data (Step 4 of 5)");
            Graph q = new Graph(qLoader, this);
            if (Common.LABELED) {
                q.SetNodeComparator(new exactNodeComparator());
                q.SetEdgeComparator(new exactEdgeComparator());
            } else {
                q.SetNodeComparator(new approxNodeComparator());
                q.SetEdgeComparator(new approxEdgeComparator());
            }
            if (this.checkTask()) {
                return;
            }
            this.taskMonitor.setPercentCompleted(-1);
            this.taskMonitor.setStatus("Start Matching... (Step 5 of 5)");
            VF2MonoState s0 = new VF2MonoState(q, db);
            if (this.checkTask()) {
                return;
            }
            this.array = new ArrayList();
            this.source = new ArrayList();
            myMatch m = new myMatch(this, this.frame);
            myInteger val = m.match(s0, this.array, this.source);
            if (this.checkTask()) {
                return;
            }
            if (val.intValue() > 0) {
                if (val.intValue() > 500) {
                    int r = JOptionPane.showConfirmDialog(this.frame, "The number of matches is " + val.intValue() + ". Do you really want to draw all matches?", "NetMatch", 0);
                    if (r == 0) {
                        this.taskMonitor.setPercentCompleted(0);
                        this.taskMonitor.setStatus("Draw results...");
                        GraphPerspective[] gpComplexArray = this.convertComplexListToNetworkList(this.array, this.target);
                        this.imageList = new Image[this.array.size()];
                        for (int i = 0; i < this.array.size(); ++i) {
                            if (this.checkTask()) {
                                return;
                            }
                            this.taskMonitor.setPercentCompleted(i * 100 / gpComplexArray.length);
                            this.imageList[i] = this.convertNetworkToImage(gpComplexArray[i], Common.imageSize, Common.imageSize);
                        }
                    } else {
                        this.imageList = null;
                    }
                } else {
                    this.taskMonitor.setPercentCompleted(0);
                    this.taskMonitor.setStatus("Draw results...");
                    GraphPerspective[] gpComplexArray = this.convertComplexListToNetworkList(this.array, this.target);
                    this.imageList = new Image[this.array.size()];
                    for (int i = 0; i < this.array.size(); ++i) {
                        if (this.checkTask()) {
                            return;
                        }
                        this.taskMonitor.setPercentCompleted(i * 100 / gpComplexArray.length);
                        this.imageList[i] = this.convertNetworkToImage(gpComplexArray[i], Common.imageSize, Common.imageSize);
                    }
                }
            }
            if (this.checkTask()) {
                return;
            }
            this.completedSuccessfully = true;
        }
        catch (Exception e) {
            this.completedSuccessfully = false;
            this.target.putClientData("NetMatch_running", (Object)new Boolean(false));
            this.taskMonitor.setException((Throwable)e, "Please check data!");
        }
        catch (Error e) {
            this.completedSuccessfully = false;
            this.target.putClientData("NetMatch_running", (Object)new Boolean(false));
            this.taskMonitor.setException((Throwable)e, "NetMatch cancelled!");
        }
    }

    public Image[] getImageList() {
        return this.imageList;
    }

    public ArrayList getArrayDest() {
        return this.array;
    }

    public ArrayList getArraySource() {
        return this.source;
    }

    private GraphPerspective convertComplexToNetwork(int[] complex, CyNetwork sourceNetwork) {
        GraphPerspective gpComplex = sourceNetwork.createGraphPerspective(complex);
        return gpComplex;
    }

    private GraphPerspective[] convertComplexListToNetworkList(ArrayList complexList, CyNetwork sourceNetwork) {
        int val = complexList.size();
        GraphPerspective[] gpComplexArray = new GraphPerspective[val];
        for (int i = 0; i < val; ++i) {
            gpComplexArray[i] = this.convertComplexToNetwork((int[])complexList.get(i), sourceNetwork);
        }
        return gpComplexArray;
    }

    private Image convertNetworkToImage(GraphPerspective gpInput, int height, int width) {
        PGraphView view = new PGraphView(gpInput);
        Iterator in = view.getNodeViewsIterator();
        while (in.hasNext()) {
            NodeView nv = (NodeView)in.next();
            String label = nv.getNode().getIdentifier();
            nv.getLabel().setText(label);
            nv.setWidth(40.0);
            nv.setHeight(40.0);
            nv.setShape(2);
            nv.setUnselectedPaint((Paint)Color.red);
            nv.setBorderPaint((Paint)Color.black);
            nv.setXPosition(view.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
            nv.setYPosition((view.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100.0) * Math.random());
        }
        Iterator ie = view.getEdgeViewsIterator();
        while (ie.hasNext()) {
            EdgeView ev = (EdgeView)ie.next();
            ev.setUnselectedPaint((Paint)Color.blue);
            ev.setTargetEdgeEnd(5);
            ev.setTargetEdgeEndPaint((Paint)Color.CYAN);
            ev.setSourceEdgeEndPaint((Paint)Color.CYAN);
            ev.setStroke((Stroke)new BasicStroke(5.0f));
        }
        Image image = view.getCanvas().getLayer().toImage(width, height, null);
        return image;
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public void setPercentageComplete(int val) {
        this.taskMonitor.setPercentCompleted(val);
    }

    public boolean checkTask() {
        if (this.interrupted) {
            this.target.putClientData("NetMatch_running", (Object)new Boolean(false));
        }
        return this.interrupted;
    }
}

