package nanomunchers.graph;
import java.util.*;
import java.awt.Color;
import java.awt.Point;

import nanomunchers.bot.NanoBot;

/*
 * Created on Oct 25, 2003
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */

/**
 * @author john doe
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class NodeSet {

	/**
	 * 
	 */

	public static final int MAX_EDGES = 4;

	Vector nodes = new Vector();
	private Vector edges = new Vector();
	Vector bots = new Vector();

	//	Node[] nodes = null;
	Node[] leafs = null;

	//	NanoBot[] bots = null;
	//	private NanoBot[] solution = new NanoBot[0];

	Color color = null;

	public static int count = 0;

	public int id = 0;
	public int MIN_BOTS = -1;
	public int time = 0;
	public int OFFICIAL_START_TIME = 0;
	public boolean solved = false;
	public boolean run = true;

	//private BotList bestState = new BotList();

	public int SLEEP = 1;
	public int ANI_SLEEP = 5;

	public NodeSet() {
		id = count++;
		System.out.println("nodeset: finished");
	}

	public void addBot(NanoBot bot) {
		bots.addElement(bot);
	}

	public NanoBot getBot(int b) {
		return (NanoBot) bots.elementAt(b);
	}

	public int getBotSize() {
		return bots.size();
	}

	public void unmarkNodes() {

		for (int i = 0; i < nodes.size(); i++) {
			getNode(i).unMark();
		}
	}

	public String toString() {

		String node = "node(id,xloc,yloc)\n";

		for (int i = 0; i < nodes.size(); i++) {
			node += getNode(i).toString() + "\n";
		}

		String edge = "\nedge(nodeid1,nodeid2)\n";
		for (int i = 0; i < edges.size(); i++) {
			Point p = (Point) edges.elementAt(i);
			edge += p.x + "," + p.y + "\n";
		}
		return node + edge;
	}
	public void clearBots() {

		for (int i = 0; i < getNodeSize(); i++) {
			getNode(i).setBot(null);
		}
		bots.removeAllElements();
	}

	public void reset() {
		System.out.println("resetting");
		unmarkNodes();
		run = true;

		time = 0;
		if (bots == null) {
			return;
		}

		for (int i = 0, c = getNodeSize(); i < c; i++) {
			Node n = getNode(i);
			n.setBot(null);
		}
		for (int i = 0, c = bots.size(); i < c; i++) {
			((NanoBot) bots.elementAt(i)).reset();
		}
		System.out.println("end resetting");
	}

	public void unmarkNodes(Node[] nodes) {

		for (int i = 0; i < nodes.length; i++) {
			nodes[i].unMark();
		}
	}

	public void unmarkNodes(Vector nodes) {

		for (int i = 0; i < nodes.size(); i++) {
			((Node) nodes.elementAt(i)).unMark();
		}
	}

	public Node[] toArray(Vector v) {
		Node[] nodes = new Node[v.size()];
		for (int i = 0, c = v.size(); i < c; i++) {
			nodes[i] = (Node) v.elementAt(i);
		}
		return nodes;
	}

	public int liveCount() {
		int count = 0;
		for (int i = 0; i < bots.size(); i++) {
			NanoBot one = (NanoBot) bots.elementAt(i);
			if (one.isAlive()) {
				count++;
			}
		}
		return count;
	}

    // this moves by step increments the visual bots
    // adjust as you deem fit, it's called in runsim.
    
	public void animate(double step) {

		for (int i = 0; i < bots.size(); i++) {
			NanoBot bot = getBot(i);
			if (bot.isAlive() && time >= bot.getStartTime()) {

				double x = bot.x - bot.getNode().getLoc().x;
				double y = bot.y - bot.getNode().getLoc().y;
				bot.distance = Math.sqrt(x * x + y * y);
			}
		}

		for (int s = 0; s < step; s++) {
			for (int i = 0; i < bots.size(); i++) {
				NanoBot bot = getBot(i);

				if (bot.isAlive() && time >= bot.getStartTime()) {
					double x = (bot.x - bot.getNode().getLoc().x);
					double y = (bot.y - bot.getNode().getLoc().y);
					double x2 = x / (Math.abs(x) + Math.abs(y));
					double y2 = y / (Math.abs(x) + Math.abs(y));

					bot.x -= bot.distance / step * x2;
					bot.y -= bot.distance / step * y2;

				}
			}
			try {
				Thread.sleep(ANI_SLEEP);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

		}
	}
	
	public void end() {
		run = false;
	}

    // I believe returning the vector was part of my solution and can be taken out, but i'm reluctant
    // to change code at this point.
	public Vector runSim() {

		System.out.println(" running simulation");
		reset();

		while ( run && liveCount() > 0) {
			
			System.out.println("time:= " + time + " alive " + liveCount());

			animate(150); // number of steps to do for animation

            // Everyone alive eats
			for (int i = 0; i < bots.size(); i++) {
				NanoBot bot = getBot(i);
				if (bot.isAlive() && time >= bot.getStartTime()) {
					bot.eat();
				}
			}
            // Everyone alive moves
			for (int i = 0; i < bots.size(); i++) {
				NanoBot bot = getBot(i);
				if (bot.isAlive() && time >= bot.getStartTime()) {

					boolean lives = bot.move();

					if (!lives) {
						((NanoBot) bots.elementAt(i)).die();
					}
				}
			}
            // check for collisions
			for (int i = 0; i < bots.size(); i++) {

				NanoBot one = (NanoBot) bots.elementAt(i);
				if (one.isAlive()) {

					for (int j = 0, k = bots.size(); j < k; j++) {
						NanoBot check = (NanoBot) bots.elementAt(j);
						if (one != check) {

							if (one.getNode() == check.getNode()) {

								// up left down right

								if (one.lastMove > check.lastMove) {
									one.die();
								}
							}

						}
					}
				}
			}

			time++;

			try {
				Thread.sleep(SLEEP);

			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		System.out.println(" ending simulation ");

		Vector v = new Vector();
		/*
		for (int i = 0; i < getNodeSize(); i++) {
			Node n = getNode(i);
			if (!n.marked) {
		
				if (n.getBot() != null) {
					System.out.println("loose bot ");
					System.out.println(4 / 0);
				}
				v.add(n);
			}
		}*/

		return v;
	}

	public void setColor(Color c) {
		color = c;
	}

	public Color getColor() {
		return color;
	}

	//	public Node NW, NE, SW, SE;

	public void addNode(Node node) {
		nodes.addElement(node);
	}

	public void addEdge(int id, int id2) {
		edges.addElement(new Point(id, id2));
	}
	public int getEdgeCount(){
	    return edges.size();
	}
	
	public Node getNode(int i) {
		return (Node) nodes.elementAt(i);
	}

	public Node getNode(int x, int y) {
		for (int i = 0; i < getNodeSize(); i++) {
			Node n = getNode(i);
			if (n.p.x == x && n.p.y == y) {
				return n;
			}
		}
		return null;
	}

	public int getNodeSize() {
		return nodes.size();
	}

	public Node getLeaf(int i) {
		return leafs[i];
	}

	public int getLeafSize() {
		return leafs.length;
	}

	public static void main(String[] args) {
	}

	Random r = new Random(1);
}
