package nanomunchers.bot;
import java.awt.*;
import java.util.*;

import nanomunchers.graph.Graph;
import nanomunchers.graph.Node;
import nanomunchers.graph.NodeSet;
/*
 * Created on Oct 24, 2003
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */

/**
 * @author john doe
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class NanoBot {

	/**
	 * 
	 */

	public static final int UP = 0;
	public static final int LEFT = 1;
	public static final int RIGHT = 2;
	public static final int DOWN = 3;

	public static int count = 0;

	public static Random r = new Random(System.currentTimeMillis());
	public static Vector v = new Vector();

	public int id = -1;

	public int[] set = null;

	private int index = 0;
	private Graph graph = null;

	private Node node = null;
	//private Node last = null;
	private Node start = null;

	public double x = 0;
	public double y = 0;
	public double distance;

	public String name = null;

	private boolean alive = true;
	private int startedAt = Integer.MAX_VALUE;

	public Color color = null;

	public int setNum = -1;
	public int lastMove = -1;

	private int score = 0;
	private int startTime = 0;

	static {

		for (int f = 0; f < 4; f++) {
			for (int s = 0; s < 4; s++) {
				for (int t = 0; t < 4; t++) {
					for (int e = 0; e < 4; e++) {

						if (f != s && f != t && f != e) {
							if (s != t && s != e) {
								if (t != e) {
									v.addElement(new int[] { f, s, t, e });
								}
							}
						}

					}
				}
			}
		}

	}

	public NanoBot() {
		super();
		// TODO Auto-generated constructor stub
	}

	public NanoBot(int i, Node start) {
		this(i, start, 0);
	}

	public NanoBot(
		String time,
		Node n,
		String f,
		String s,
		String t,
		String ft) {

		color =
			new Color(
				Math.abs(r.nextInt()) % 255,
				Math.abs(r.nextInt()) % 255,
				Math.abs(r.nextInt()) % 255);

		startTime = Integer.parseInt(time);
		setStart(n);
		//	setNode(n);
		set =
			new int[] {
				stringInt(f),
				stringInt(s),
				stringInt(t),
				stringInt(ft)};

	}

	public static int stringInt(String s) {

		if ("left".equalsIgnoreCase(s.trim())) {
			return LEFT;
		}
		if ("right".equalsIgnoreCase(s.trim())) {
			return RIGHT;
		}
		if ("up".equalsIgnoreCase(s.trim())) {
			return UP;
		}
		if ("down".equalsIgnoreCase(s.trim())) {
			return DOWN;
		}
		return -1;
	}

	public NanoBot(int i, Node start, int time) {

		startTime = time;
		id = count++;
		setSet(i);
		this.start = start;
		setNode(start);
		node.setBot(this);
		color =
			new Color(
				Math.abs(r.nextInt()) % 255,
				Math.abs(r.nextInt()) % 255,
				Math.abs(r.nextInt()) % 255);

		if (start.getRawPoint().x == 5 && start.getRawPoint().y == 9) {
			set = new int[] { UP, LEFT, DOWN, RIGHT };
		}

	}

	public NanoBot(NanoBot n) {
		setSet(n.setNum);
		start = n.start;
		node = n.getNode();
		color = n.color;
		id = n.id;
	}

	public void setStart(Node n) {
		start = n;
	}

	public int getStartTime() {
		return startTime;
	}

	public Node getStart() {
		return start;
	}

	public void reset() {
		if (start != null) {
			start.setBot(this);
			setNode(start);
			index = 0;
			alive = true;
		} else {
			alive = false;
		}
	}

	public void setSet(int i) {
		set = (int[]) v.elementAt(i);
		setNum = i;
	}

	public void setNode(Node n) {
		node = n;

		node.setBot(this);

	}

	public Node getNode() {
		return node;
	}

	public void eat() {
		x = node.getLoc().x;
		y = node.getLoc().y;
		if (node.isMarked()) {
			die();
		}
		node.mark(this);

	}

	public void setGraph(Graph g) {
		graph = g;
	}

	public void die() {
		alive = false;
	}

	public void live() {
		alive = true;
	}

	public boolean isAlive() {
		return alive;
	}

	public String move(int i) {

		switch (i) {

			case LEFT :
				return "left";
			case UP :
				return "up";
			case RIGHT :
				return "right";
			case DOWN :
				return "down";

		} // switch
		return "error";
	}

	public int getIndex() {
		return index;
	}

	public String toString() {
		return start.getRawPoint().x
			+ " "
			+ start.getRawPoint().y
			+ "  current "
			+ node.getRawPoint().x
			+ " : "
			+ node.getRawPoint().y
			+ "   :"
			+ move(set[0])
			+ " "
			+ move(set[1])
			+ " "
			+ move(set[2])
			+ " "
			+ move(set[3])
			+ " "
			+ alive;
	}

	public boolean move() {
		boolean valid = false;

		Node moveNode = null;
		int currentIndex = index;

		while (alive) {

			int s = getMove(index);

			switch (s) {

				case LEFT :
					moveNode = node.getEdge(LEFT);
					break;
				case UP :
					moveNode = node.getEdge(UP);
					break;
				case RIGHT :
					moveNode = node.getEdge(RIGHT);
					break;
				case DOWN :
					moveNode = node.getEdge(DOWN);
					break;
			} // switch

			lastMove = getMove(index);

			index++;

			if (moveNode != null && !moveNode.isMarked()) {

				setNode(moveNode);
				return true;
			} else if (index == currentIndex + NodeSet.MAX_EDGES) {
				return false;
			}
		}
		return false;
	}

	public int getMove(int index) {
		return set[index % set.length];
	}

}
