package nanomunchers.ui;


import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

import nanomunchers.graph.KGraph;
/*
 * Created on Oct 30, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoDecisionPanel extends Component {
    Graphics bufferGraphics;
	Image offscreen;
	Vector showPoints = new Vector();
	Point mLocation = null;
	Point possible = null;
	GraphDrawing graphDrawing = new GraphDrawing();
	KGraph graph;
	int woffset,hoffset;
	int lastWidth,lastHeight;
	
	public NanoDecisionPanel(){
        NanoGridWatcher gridWatcher = new NanoGridWatcher();
        addMouseListener(gridWatcher);
        addMouseMotionListener(gridWatcher);
	}
	public void setGraph(KGraph graph){
	    this.graph = graph;
	    graphDrawing.setGraph(graph);
	}
	public void clear(){
	    showPoints.clear();
	}
	public boolean commitPoint(){
	    if (possible != null){
	        showPoints.add(possible);
	        possible = null;
	        return true;
	    }
	    return false;
	}
	public Point getRecentPoint(){
	    if (showPoints.size()<1){
	        return null;
	    }
	    return (Point)showPoints.get(showPoints.size()-1); 
	}
	
	public void paint(Graphics g){
        update(g);
    }
    public void update(Graphics g){
        if (graph==null){
            g.drawString("No Graph Loaded",10,10);
            return;
        }
        int width = getWidth();
        int height = getHeight();
        if (offscreen == null || (width != lastWidth) || (height != lastHeight)) {
			offscreen = createImage(width, height);
			bufferGraphics = offscreen.getGraphics();
		}
        lastWidth = width;
        lastHeight = height;
        bufferGraphics.setColor(Color.BLACK); 
		bufferGraphics.fillRect(0, 0, width, height);
        
        woffset = width/(graph.getWidth()+1);//still needed for mouse listeners
        hoffset = height/(graph.getHeight()+1);
        bufferGraphics.setColor(Color.GRAY);
        graphDrawing.drawGraph(bufferGraphics,Color.GRAY,width,height);
        if (mLocation != null){
            bufferGraphics.setColor(Color.WHITE);
            bufferGraphics.drawString("("+mLocation.x+","+mLocation.y+")",10,10);
        }
        Color c = Color.WHITE;
        for(int i=0;i<showPoints.size();i++){
            Point p = (Point)showPoints.get(i);
            int px = woffset + woffset*p.x;
            int py = hoffset + hoffset*p.y;
            graphDrawing.drawBotAlive(bufferGraphics,c,px,py,px,py);
        }
        c = Color.GREEN;
        if (possible != null){
            int px = woffset + woffset*possible.x;
            int py = hoffset + hoffset*possible.y;
            graphDrawing.drawBotAlive(bufferGraphics,c,px,py,px,py);
        }
        //g.translate(0,1);
        g.drawImage(offscreen, 0, 0, this);
    }
	
	class NanoGridWatcher extends MouseAdapter implements MouseMotionListener{
        public void mouseClicked(MouseEvent e){
            if (woffset==0 || hoffset==0) return;
            int ex = e.getX();
            int ey = e.getY();
            ex = (ex-woffset/2)/woffset;
            ey = (ey-hoffset/2)/hoffset;
            if (((ex >= 0) && (ex < getWidth())) &&
                    ((ey >= 0) && (ey < getHeight()))){
                possible = new Point(ex,ey);
            }
            repaint();
        }

        /** 
         * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
         */
        public void mouseDragged(MouseEvent e) {
        }

        /** 
         * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
         */
        public void mouseMoved(MouseEvent e) {
            if (woffset==0 || hoffset==0) return;
            int ex = e.getX();
            int ey = e.getY();
            ex = (ex-woffset/2)/woffset;
            ey = (ey-hoffset/2)/hoffset;
            if (((ex >= 0) && (ex < getWidth())) &&
                    ((ey >= 0) && (ey < getHeight()))){
                mLocation = new Point(ex,ey);
            }
        }
    }

}
