package nanomunchers.ui;

import heurgame.ui.DisplayUtilities;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import nanomunchers.graph.KGraph;
import nanomunchers.graph.KGraphFactory;
/*
 * Created on Oct 29, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class GraphGeneration extends Container {
    public static final int GRAPH_COMPLETE = 0;
    public static final int GRAPH_RANDOM = 1;
    public static final int GRAPH_FILE = 2;
    public static final int GRAPH_URL = 3;
    private int graphOption = 0;
    private Choice graphTypes = new Choice();
    private TextField widthText = new TextField(3);
    private TextField heightText = new TextField(3);
    private TextField randomText = new TextField(3);;
    private TextField urlText = new TextField(40);;
    private Button browseButton = new Button("Browse");
    private Label widthLabel=new Label("Width");
    private Label heightLabel=new Label("Height");
    private Label percentageLabel= new Label("Average nodes remaining");
    private Label fileLabel = new Label("(no file selected)");
    private Label status = new Label("");
    private Runnable onFinish;
    private KGraph product;
    private boolean readyToGenerate = false;
    
    private String useFileOrURL = new String();
    private int useWidth = 10;
    private int useHeight = 10;
    private int useRandom = 50;
    
    private FileDialog browseWindow;
    /**
     * 
     */
    public GraphGeneration() {
        super();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2,2,2,2);
        setLayout(gb);
        constraints.gridwidth = 1;
        constraints.weightx = 0;
        Label graphType = new Label("Graph Type");
        gb.setConstraints(graphType,constraints);
        constraints.weightx = 1;
        add(graphType);
        
        graphTypes.add("Complete Grid");
        graphTypes.add("Partial Grid");
        graphTypes.add("Local File");
        graphTypes.add("HTTP URL");
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.weightx=2;
        gb.setConstraints(graphTypes,constraints);
        add(graphTypes);
        
        urlText.setText("http://");
        constraints.weightx=0;
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        gb.setConstraints(urlText,constraints);
        add(urlText);
        
        constraints.gridwidth = 1;
        gb.setConstraints(fileLabel,constraints);
        add(fileLabel);
        
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        gb.setConstraints(browseButton,constraints);
        add(browseButton);
        
        constraints.gridwidth = 1;
        gb.setConstraints(percentageLabel,constraints);
        add(percentageLabel);
        
        gb.setConstraints(randomText,constraints);
        add(randomText);
        
        constraints.gridwidth =1;
        gb.setConstraints(widthLabel,constraints);
        add(widthLabel);
        
        gb.setConstraints(widthText,constraints);
        add(widthText);
        
        gb.setConstraints(heightLabel,constraints);
        add(heightLabel);
        
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        gb.setConstraints(heightText,constraints);
        add(heightText);
        
        
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.weightx= 5;
        constraints.fill= GridBagConstraints.BOTH;
        gb.setConstraints(status,constraints);
        add(status);
        
        //stitching the Listeners together
        graphTypes.addItemListener(new GraphChoiceListener());
        
        
        browseButton.addActionListener(new ActionListener(){
            	public void actionPerformed(ActionEvent e){
            	    browseWindow = new FileDialog((Frame) DisplayUtilities.getParentWindow(GraphGeneration.this), "Browse", FileDialog.LOAD);
            	    browseWindow.show();
            	    if (browseWindow.getDirectory() !=null){
            	        String filename = browseWindow.getDirectory() + browseWindow.getFile();
            	        fileLabel.setText(filename);
            	    }
            	    DisplayUtilities.ensureWindowFits(GraphGeneration.this);
            	}
        	}
        );
        
    }
    public boolean generateGraph(){
        double percentage = -1;
        int width = -1;
        int height = -1;
        String errorMessage = "";
        status.setText("Working");
        
        //Step 1 validate input
        try {
            switch (graphOption){
        		case GraphGeneration.GRAPH_RANDOM:
        	    	int percent = Integer.parseInt(randomText.getText());
        			percentage = (double)percent/(double)100;
        		case GraphGeneration.GRAPH_COMPLETE:
        		    width  = Integer.parseInt(widthText.getText());
        			height = Integer.parseInt(heightText.getText());
        			break;
        	}
        } catch (NumberFormatException nfe){
            errorMessage = "Invalid: ";
	        if (percentage <= 0 && graphOption==GraphGeneration.GRAPH_RANDOM){
	            errorMessage+="Average Nodes Specified";
	        }else  if (width <= 0){
	            errorMessage+="Width";
	        }else if (height <= 0){
	            errorMessage+="Height";
	        }
	        
	    }
        
        try {
            switch (graphOption){
    			case GraphGeneration.GRAPH_RANDOM:
    			    product = KGraphFactory.buildGridGraph(width,height);
    				product = KGraphFactory.buildRandomized(product,percentage);
    			    break;
    			case GraphGeneration.GRAPH_COMPLETE:
    			    product = KGraphFactory.buildGridGraph(width,height);
    			    break;
    			case GraphGeneration.GRAPH_URL:
    			    product = KGraphFactory.loadHttpURL(urlText.getText());
    			    break;
    			case GraphGeneration.GRAPH_FILE:
    			    product = KGraphFactory.loadFile(fileLabel.getText());
    			    break;
            }
        }catch (Exception ex){
            //NullPointers will be thrown anyway, lets get the interesting ones
            if (ex.getClass().getName().equals("java.lang.NullPointException")==false){
                errorMessage += ex.toString();
            }
        }
        if (errorMessage.length()>0){
            status.setText(errorMessage);
            return false;
        }
        status.setText("Generation Complete");
        return true;
    }
    public void setFinishingAction(Runnable r){
        onFinish = r;
    }
    public void setup(int mode,int width,int height,int randomKept,String fileOrURL){
        useWidth =width;
        useHeight = height;
        useRandom = randomKept;
        useFileOrURL = fileOrURL;
        setMode(mode);
    }

    public void setMode(int mode){
        graphOption = mode;
        percentageLabel.setVisible(false);
	    randomText.setVisible(false);
	    browseButton.setVisible(false);
	    fileLabel.setVisible(false);
	    urlText.setVisible(false);
	    widthText.setVisible(false);
    	heightText.setVisible(false);
    	widthLabel.setVisible(false);
    	heightLabel.setVisible(false);

	    switch (graphOption){
        	case GraphGeneration.GRAPH_RANDOM://NOTE THIS USES FALLTHROUGH
        	    randomText.setText(""+useRandom);
        	    percentageLabel.setVisible(true);
        	    randomText.setVisible(true);
        	case GraphGeneration.GRAPH_COMPLETE:
        	    widthText.setText(""+useWidth);
        	    heightText.setText(""+useHeight);
        	    widthText.setVisible(true);
        	    heightText.setVisible(true);
        	    widthLabel.setVisible(true);
        	    heightLabel.setVisible(true);
        	    break;
        	case GraphGeneration.GRAPH_FILE:
        	    if (useFileOrURL.startsWith("http://")==false){
        	        fileLabel.setText(useFileOrURL);
        	    }
        	    browseButton.setVisible(true);
        	    fileLabel.setVisible(true);
        	    break;
        	case GraphGeneration.GRAPH_URL:
        	    if (useFileOrURL.startsWith("http://")){
        	        urlText.setText(useFileOrURL);
        	    }
    	    	urlText.setVisible(true);
        	    break;
        }
	    DisplayUtilities.ensureWindowFits(this);
    }
    public int getProductType(){
        return graphOption;
    }
    public KGraph getGraph(){
        return product;
    }
    public static void main(String args[]){
        final Frame f = new Frame("Graph Editor");
        f.setLayout(new java.awt.BorderLayout());
        //GraphEditPanel gep = new GraphEditPanel();
        GraphGeneration gg = new GraphGeneration();
        
        f.add(gg);
        gg.setup(GraphGeneration.GRAPH_COMPLETE,20,20,85,"http://www.moose.com");
        gg.setSize(500,350);
        f.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                f.dispose();
                System.exit(1);
            }
        });
        f.pack();
        f.show();
    }
    protected class GraphChoiceListener implements ItemListener{

        /** 
         * @see java.awt.event.ItemListener#itemStateChanged(java.awt.event.ItemEvent)
         */
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == ItemEvent.SELECTED){
                int whatType = graphTypes.getSelectedIndex();
                setMode(whatType);
            }
            
        }
    }
}
