package nanomunchers.graph;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class KGraphFactory {
    public static KGraph buildRandomized(KGraph src, double chanceNodeRemoved){
        Vector keepNodes = new Vector();
        Vector killNodes = new Vector();
        Vector keepEdges = new Vector();
        KNode[] nodes = src.getNodes();
        KEdge[] edges = src.getUniqueEdges();
        for(int i=0;i<nodes.length;i++){
            if (Math.random()>chanceNodeRemoved){
                killNodes.add(nodes[i]);
            }else{
                keepNodes.add(nodes[i]);
            }
        }
        for(int e=0;e<edges.length;e++){
            boolean keep = true;
            for(int i=0;i<killNodes.size();i++){
                KNode killNode = (KNode)killNodes.get(i);
                if (edges[e].doesContain(killNode)){
                    keep = false;
                    break;
                }
            }
            if (keep){
                keepEdges.add(edges[e]);
            }
        }
        KEdge[] finalEdges = new KEdge[keepEdges.size()];
        KNode[] finalNodes = new KNode[keepNodes.size()];
        for(int i=0;i<finalNodes.length;i++){
            finalNodes[i] = (KNode)keepNodes.get(i); 
        }
        for(int j=0;j<finalEdges.length;j++){
            finalEdges[j] = (KEdge)keepEdges.get(j);
        }
        return buildFromParts(finalNodes,finalEdges);
    }
    public static KGraph buildFromParts(KNode[] nodes, KEdge[] edges){
        return new KGeneralGraph(nodes,edges);
    }
    public static KGraph buildGridGraph(int width,int height){
        return new KGridGraph(width,height);
    }
    public static void saveFile(String name,KGraph toSave) throws IOException{
            PrintWriter pw = new PrintWriter(new FileWriter(name));
            pw.println("#Automatically Generated Graph");
            pw.println("#Nodes start here");
            KNode[] nodes = toSave.getNodes();
            for(int i=0;i<nodes.length;i++){
                pw.print(nodes[i].getId());
                pw.print(',');
                pw.print(nodes[i].getX());
                pw.print(',');
                pw.println(nodes[i].getY());
            }
            KEdge[] edges = toSave.getUniqueEdges();
            for(int i=0;i<edges.length;i++){
                pw.print(edges[i].getNodes()[0].getId());
                pw.print(',');
                pw.println(edges[i].getNodes()[1].getId());
            }
            pw.flush();
            pw.close();
    }
    
    public static KGraph loadHttpURL(String url) throws IOException{
        URL netRef;
            netRef = new URL(url);
            HttpURLConnection httpUrl = (HttpURLConnection) netRef.openConnection();
            httpUrl.setRequestMethod("GET");
            httpUrl.setInstanceFollowRedirects(true);
            httpUrl.setDoInput(true);
            return loadFromReader(new InputStreamReader(httpUrl.getInputStream()));
    }
    
    public static KGraph loadFile(String name) throws FileNotFoundException{
            return loadFromReader(new FileReader(name));
    }
    private static KGraph loadFromReader(Reader reader){
        KNode[] nodes;
        KEdge[] edges;
        Vector nodeLines = new Vector();
        Vector edgeLines = new Vector();
        System.out.println("Loading Graph...");
        try {
            BufferedReader br = new BufferedReader(reader);
            String line = "";
            while(br.ready() && line != null){
                line = br.readLine();
                String[] parts = line.split(",");
                if ((parts[0].length()> 0) && Character.isDigit(parts[0].charAt(0))==true){
                    //This is NOT a comment
                    if (parts.length==3){
                        //Node
                        nodeLines.add(new KNode(null, Integer.parseInt(parts[0]),
                                Integer.parseInt(parts[1]), 
                            Integer.parseInt(parts[2])));
                    }
                    if (parts.length==2){
                        //Edge
                        KNode a = (KNode) nodeLines.get(Integer.parseInt(parts[0]));
                        KNode b = (KNode) nodeLines.get(Integer.parseInt(parts[1]));
                        if (a.getId()==97 && b.getId()==98){
                            //We read it!
                        }
                        edgeLines.add(new KEdge(a,b));
                    }
                }
            }
            br.close();
            nodes = new KNode[nodeLines.size()];
            edges = new KEdge[edgeLines.size()];
            for(int i=0;i<nodeLines.size();i++){
                nodes[i] = (KNode)nodeLines.get(i);
            }
            for(int j=0;j<edgeLines.size();j++){
                edges[j] = (KEdge)edgeLines.get(j);
            }
            System.out.println("Loading Graph DONE");
            return new KGeneralGraph(nodes,edges);
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }
}
