package nanomunchers.graph;

import java.util.Vector;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
class KGeneralGraph implements KGraph {
    private KNode[] nodes;
    private KEdge[] edges;
    
    private int width;
    private int height;
    
    protected KGeneralGraph(KNode[] inNodes, KEdge[] inEdges){
        reassignNodes(inEdges);
    }
    private void reassignNodes(KEdge[] inEdges){
        Vector knownInformation = new Vector();
        Vector knownNodes = new Vector();
        int width = 0;
        int height = 0;
        for(int i=0;i<inEdges.length;i++){
            KNode[] edges = inEdges[i].getNodes();
            Integer a = new Integer(edges[0].getId());
            Integer b = new Integer(edges[1].getId());
            if (knownNodes.contains(a)==false){
                knownNodes.add(a);
                knownInformation.add(edges[0]);
                if (edges[0].getX()>width){
                    width = edges[0].getX();
                }
                if (edges[0].getY()>height){
                    height = edges[0].getY();
                }
            }
            if (knownNodes.contains(b)==false){
                knownNodes.add(b);
                knownInformation.add(edges[1]);
                if (edges[1].getX()>width){
                    width = edges[1].getX();
                }
                if (edges[1].getY()>height){
                    height = edges[1].getY();
                }
            }
        }
        //Generate the new nodes
        nodes = new KNode[knownNodes.size()];
        for(int i=0;i<nodes.length;i++){
            KNode basis = (KNode)knownInformation.get(i);
            nodes[i] = new KNode(this,i,basis.getX(),basis.getY());
        }
        //Generate the new edges
        edges = new KEdge[inEdges.length];
        for(int e=0;e<edges.length;e++){
            KEdge original = inEdges[e];
            KNode[] nodeRef = original.getNodes();
            int idOldOne = nodeRef[0].getId();
            int idOldTwo = nodeRef[1].getId();
            int newIdOne = knownNodes.indexOf(new Integer(idOldOne));
            int newIdTwo = knownNodes.indexOf(new Integer(idOldTwo));
            edges[e] = new KEdge(nodes[newIdOne],nodes[newIdTwo]);
        }
        this.width = width + 1;
        this.height = height + 1;
    }
    /** 
     * @see nanomunchers.graph.KGraph#getNodes()
     */
    public KNode[] getNodes() {
        return nodes;
    }

    /** 
     * @see nanomunchers.graph.KGraph#getUniqueEdges()
     */
    public KEdge[] getUniqueEdges() {
        return edges;
    }

    /** 
     * @see nanomunchers.graph.KGraph#getConnectedComponents()
     */
    public KGraph[] getConnectedComponents() {
        clear();
        boolean allSeen = false;
        Vector graphs = new Vector();
        while(allSeen == false){
            allSeen = true;
            int index = 0;
            for(index=0;index<nodes.length;index++){
                allSeen = allSeen && nodes[index].isMarked();
                if (allSeen==false){
                    break;
                }
            }
            Vector ccNodes = new Vector();
            Vector ccEdges = new Vector();
            connectedComponentBuilder(nodes[index],ccNodes,ccEdges);
            KNode[] newNodes = new KNode[ccNodes.size()];
            KEdge[] newEdges = new KEdge[ccEdges.size()];
            for(int i=0;i<newNodes.length;i++){
                newNodes[i] = (KNode)ccNodes.get(i);
            }
            for(int j=0;j<newEdges.length;j++){
                newEdges[j]= (KEdge)ccEdges.get(j);
            }
            graphs.add(KGraphFactory.buildFromParts(newNodes,newEdges));
        }
        KGraph[] cc = new KGraph[graphs.size()];
        for(int i=0;i<graphs.size();i++){
            cc[i] = (KGraph)graphs.get(i);
        }
        clear();
        return cc;
    }
    private void connectedComponentBuilder(KNode start,Vector vnodes,Vector vedges){
        vnodes.add(start);
        start.mark();
        KEdge[] neighbors = getNeighbors(start);
        Vector otherlist = new Vector();
        for(int n=0;n<neighbors.length;n++){
            KNode other = neighbors[n].getOther(start);
            if (other.isMarked()==false){
                otherlist.add(other);
                vedges.add(neighbors[n]);
            }
        }
        for(int i=0;i<otherlist.size();i++){
            KNode next = (KNode)otherlist.get(i);
            connectedComponentBuilder(next,vnodes,vedges);
        }
        
    }
    /** 
     * @see nanomunchers.graph.KGraph#clear()
     */
    public void clear() {
        for(int i=0;i<nodes.length;i++){
            nodes[i].clear();
        }
    }

    /** 
     * @see nanomunchers.graph.KGraph#getNeighbors(nanomunchers.graph.KNode)
     */
    public KEdge[] getNeighbors(KNode n) {
        Vector neighbors = new Vector();
        for(int i=0;i<edges.length;i++){
            KEdge test = edges[i];
            if (test.doesContain(n)){
                neighbors.add(test);
            }
        }
        KEdge[] ret = new KEdge[neighbors.size()];
        for(int i=0;i<ret.length;i++){
            ret[i] = (KEdge)neighbors.get(i);
        }
        return ret;
    }
    public int getWidth(){ return width;}
    public int getHeight() { return height;}
}
