package nanomunchers;

import java.awt.Point;

import nanomunchers.bot.KNanoBot;
import nanomunchers.graph.KGraph;
import nanomunchers.graph.KNode;
import heurgame.PlayerToken;
import heurgame.analysis.MoveAnalyzer;
/*
 * Created on Oct 21, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class NanoMoveAnalyzer extends MoveAnalyzer {
    private KGraph bounds;
    private NanoSystemAnalyzer parent;
    
    public NanoMoveAnalyzer(NanoSystemAnalyzer parent){
        this.parent = parent;
    }
    /** 
     * @see heurgame.analysis.MoveAnalyzer#evaluateMove(java.lang.String, heurgame.PlayerToken, long)
     */
    public String evaluateMove(String move, PlayerToken senderToken,
            long timeTaken) {
        if (move==null || move.length()<5){
            return MoveAnalyzer.MOVE_DISQUALIFIED+"Null Move";
        }
        bounds = parent.getBoard();
        String[] parts = move.split(" ");
        Point p = new Point(Integer.parseInt(parts[0]),
                            Integer.parseInt(parts[1]));
        String rest = parts[2]+" "+parts[3]+ " "+parts[4]+" "+parts[5];
        KNode[] validPoints =bounds.getNodes();
        KNode actualStartPoint = null;
        for(int i=0;i<validPoints.length;i++){
            KNode thisPoint = validPoints[i];
            if (thisPoint.getPoint().equals(p)){
                actualStartPoint = thisPoint;
                break;
            }
        }
        if (actualStartPoint==null){
            return MoveAnalyzer.MOVE_INVALID+"OUTSIDE";
        }
        KNanoBot bot = new KNanoBot(rest, actualStartPoint);
        System.out.println("Bot created: "+bot.getDirection());
        String systemResponse = parent.getResponse(senderToken,bot);
        if (systemResponse.equals("DUPLICATE") ||systemResponse.equals("Too many bots") ){ 
            return MoveAnalyzer.MOVE_INVALID+systemResponse;
        }
        return MoveAnalyzer.MOVE_VALID + systemResponse;
    }
}
