package heurgame;

import heurgame.event.TimeBroadcaster;
import heurgame.event.TimeEvent;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class TimeKeeper implements Runnable{
    protected volatile long normalTimeLeft;
    protected volatile long warningTimeLeft;
    protected volatile boolean paused;
    protected volatile boolean stopped;
    protected volatile boolean expired;
    protected Referee ref;
    protected PlayerToken player;
    protected TimeBroadcaster timeBroadcaster;
    
    public TimeKeeper(TimeBroadcaster tb, PlayerToken p, Referee r, long normal, long warn){
        timeBroadcaster = tb;
        player = p;
        ref = r;
        normalTimeLeft = normal;
        warningTimeLeft = warn;
        paused = true;
        stopped =false;
        expired=false;
        System.out.println(""+player.getName()+" has "+ normalTimeLeft +" with "+ warningTimeLeft+" extra");
    }
    /** 
     * @see java.lang.Runnable#run()
     */
    public void run() {
        while((normalTimeLeft >= 0) && (warningTimeLeft > 0)){
            long then = System.currentTimeMillis();
            try {
                Thread.sleep(250);
            } catch (InterruptedException ie){
                //DO NOTHING
                ie.printStackTrace();
            }
            long diff =  System.currentTimeMillis() - then;
            if (stopped){
                return;
            }
            if (paused){
                continue;
            }
            //updateTime();
            
            if (diff < 1){//This should not happen!
                diff = 1;
            }
            if (normalTimeLeft > 0){
                normalTimeLeft -= diff;
                if (normalTimeLeft <= 0){
                    normalTimeLeft = 0;
                    //send the warning
                    warn();
                }
            }else{
                //we are already in the warning time
                warningTimeLeft -= diff;
                if (warningTimeLeft < 0){
                    warningTimeLeft = 0;
                }
            }
            updateTime();
        }
        expired = true;
        if ((warningTimeLeft + normalTimeLeft) == 0){
            timeUp();
        }
    }
    public void pause(){
        paused = true;
    }
    public void unPause(){
        paused = false;
    }
    public boolean isPaused(){
        return paused;
    }
    public void stop(){
        stopped = true;
    }
    public boolean isExpired(){
        return expired;
    }
    public void warn(){
        System.out.println("Player Warned");
        ref.warnPlayer(this.player,""+this.warningTimeLeft);
    }
    public void timeUp(){
        System.out.println("Time Expiring");
        ref.disqualifyPlayer(this.player,"Time Expired");
    }
    public void updateTime(){
        TimeEvent e = new TimeEvent();
        e.normalTimeRemaining = this.normalTimeLeft;
        e.totalTimeRemaining =  this.normalTimeLeft + this.warningTimeLeft;
        e.who = this.player;
        timeBroadcaster.announceTimeChanged(e);
        //System.out.println(""+player.getName()+" has "+ normalTimeLeft +" with "+ warningTimeLeft+" extra");
    }
}
