package nanomunchers.graph;

import java.util.Vector;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class KGridGraph implements KGraph {
    protected KNode[] nodes;
    protected KEdge[] edges;
    protected int graphwidth;
    protected int graphheight;
    
    protected KGridGraph(int width, int height){
        //Step 1 Calculate Nodes
        this.graphwidth = width;
        this.graphheight = height;
        int nodeCount = (width)*(height);
        nodes = new KNode[nodeCount];
        int id=0;
        for(int h=0;h<height;h++){
            for(int w=0;w<width;w++){
              nodes[id] = new KNode(this,id,w,h);
              id++;
           }
        }
        //Step 2 Calculate Edges
        int numEdges = (2*(height -1)*(width-1 )) + (height -1 ) + (width - 1);
        edges = new KEdge[numEdges];
        int edgeCount = 0;
        for(int i=0;i<(nodes.length - 1);i++){
            KNode n = nodes[i];
            int yloc = n.getY();
            int xloc = n.getX();
            if ((xloc< (width-1)) && (yloc < (height -1))){
                //right side
                edges[edgeCount] = new KEdge(n,nodes[xloc+1+ width*yloc]);
                edgeCount++;

                edges[edgeCount] = new KEdge(n,nodes[xloc+ width*yloc + width]);
                edgeCount++;
            }else if (n.getX() == (width -1)){
                //bottom side (now filling in the edges that would
                //make the rightmost edge of the rectangle)
                edges[edgeCount] = new KEdge(n,nodes[xloc+ width*yloc + width]);
                edgeCount++;
            }else{
                //add the right edge (now filling in the bottom of the
                //graph)
                edges[edgeCount] = new KEdge(n,nodes[xloc+1+ width*yloc]);
                edgeCount++;
            }
        }
    }
    /** 
     * @see nanomunchers.graph.KGraph#getNodes()
     */
    public KNode[] getNodes() {
        return nodes;
    }

    /** 
     * @see nanomunchers.graph.KGraph#getUniqueEdges()
     */
    public KEdge[] getUniqueEdges() {
        return edges;
    }

    /** 
     * Really simple.  The entire graph is fully connected.
     * 
     * @see nanomunchers.graph.KGraph#getConnectedComponents()
     */
    public KGraph[] getConnectedComponents() {
        KGraph[] ret = new KGraph[1];
        ret[0] = this;
        return ret;
    }

    /** 
     * @see nanomunchers.graph.KGraph#clear()
     */
    public void clear() {
        for(int i=0;i<nodes.length;i++){
            nodes[i].clear();
        }
    }

    /** 
     * @see nanomunchers.graph.KGraph#getNeighbors(nanomunchers.graph.KNode)
     */
    public KEdge[] getNeighbors(KNode n) {
        Vector neighbors = new Vector();
        for(int i=0;i<edges.length;i++){
            KEdge test = edges[i];
            if (test.doesContain(n)){
                neighbors.add(test);
            }
        }
        KEdge[] ret = new KEdge[neighbors.size()];
        for(int i=0;i<ret.length;i++){
            ret[i] = (KEdge)neighbors.get(i);
        }
        return ret;
    }
    public int getWidth(){ return graphwidth;}
    public int getHeight(){ return graphheight;}
}
