package heurgame.event;
/*
 * Created on Oct 26, 2004
 */
import java.util.List;
import java.util.Iterator;
import java.util.Vector;
/**
 * @author David Kaplin
 *
 */
public class TimeBroadcaster {
    protected List listeners;
    protected boolean simultaneous;
    
    public TimeBroadcaster(){
        listeners = new Vector();
        simultaneous = false;
    }
    public void addTimeListener(TimeListener t){
        if (listeners.contains(t)){
            return;
        }
        listeners.add(t);
    }
    public void removeTimeListener(TimeListener t){
        listeners.remove(t);
    }
    public void removeAllTimeListeners(){
        listeners.clear();
    }
    public void announceTimeChanged(TimeEvent e){
        dispatch(e);
    }
    protected void dispatch(final TimeEvent e){
        Iterator i = listeners.iterator();
        while(i.hasNext()){
            final TimeListener t = (TimeListener)i.next();
            if (simultaneous){
                Thread timeThread = new Thread(){
                    public void run(){
                        t.timeChanged(e);
                    }
                };
                timeThread.start();
            }else{
                t.timeChanged(e);
            }
        }
    }
}
