package heurgame.event;

/**
 * @author David Kaplin
 *
 * A catch all for player specific information
 */
public interface PlayerListener {
    /**
     * Notificies listeners when a player enters the game.
     * 
     * @param e Player Specific information
     */
    abstract public void playerJoined(PlayerEvent e);
    /**
     * Notifies listeners when a player leaves the game.
     * 
     * @param e Player Specific information
     */
    abstract public void playerLeft(PlayerEvent e);
    /**
     * May be sent as a status message or a return from validation
     * from analysis
     *  
     * @param e Information about the Player and the status of the Move
     */
    abstract public void playerMoved(PlayerEvent e);
    /**
     * For implementation defined use
     * 
     * @param e Implementation defined
     */
    abstract public void playerStatusChanged(PlayerEvent e);
}
