package nanomunchers.ui;

import heurgame.PlayerToken;
import heurgame.event.PlayerBroadcaster;
import heurgame.event.PlayerEvent;
import heurgame.ui.PlayerColors;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
//import java.awt.Point;
//import java.awt.event.MouseEvent;
//import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import nanomunchers.bot.KNanoBot;
import nanomunchers.graph.KEdge;
import nanomunchers.graph.KGraph;
//import nanomunchers.graph.KGraphFactory;
import nanomunchers.graph.KNode;
/*
 * Created on Oct 27, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoSimulation extends Canvas {
    private KGraph graph;
    Graphics bufferGraphics;
	Image offscreen;
	int hoffset,woffset;
	int lastWidth=-1;
	int lastHeight = -1;
	private PlayerColors playerColors;
	private PlayerToken[] eaten;
	private Vector edgeLookup;
	private Vector currentFrame;
	private Vector allFrames;
	private Hashtable nanoLookup;
	private Hashtable playerLookup;
	double interpolation = .1;
	double currentPosition = 0;
	private Hashtable nanoPlacesStart;
	private Hashtable nanoPlacesEnd;
	private PlayerBroadcaster playerSpeaker;
	
	public void setup(KGraph graph){

	    this.graph = graph;
	    eaten = new PlayerToken[graph.getUniqueEdges().length];
	    edgeLookup = new Vector();
	    for(int i=0;i<graph.getNodes().length;i++){
	        edgeLookup.add(graph.getNodes()[i]);
	        //eaten[i]=null;
	    }
	    for(int i=0;i<eaten.length;i++){
	        eaten[i] = null;
	    }
	    nanoLookup = new Hashtable();
	    playerLookup = new Hashtable();
	    nanoPlacesStart = new Hashtable();
	    nanoPlacesEnd = new Hashtable();
	    currentFrame = new Vector();
	    allFrames = new Vector();
	}
	public Integer register(PlayerToken owner, KNanoBot nb){
	    Integer id = new Integer(nanoLookup.size());
	    nanoLookup.put(id,nb);
	    playerLookup.put(id,owner);
	    return id;
	}
	public void nextMove(Integer nanoId, KNode place,int munched,boolean alive){
	    NanoBit bit = new NanoBit();
	    bit.id = nanoId;
	    bit.spot = place;
	    bit.dead = !alive;
	    bit.munched = munched;
	    graph = place.getGraph();
	    currentFrame.add(bit);
	}
	public void nextFrame(){
	    System.out.println("Next Frame called "+ allFrames.size());
	    allFrames.add(currentFrame);
	    currentFrame = new Vector();
	}
	public void play(){
	    graph.clear();
	    for(int i=0;i<eaten.length;i++){
	        eaten[i]=null;
	    }
	    for(int i=0;i<nanoLookup.size();i++){
	        KNanoBot bot = (KNanoBot)nanoLookup.get(new Integer(i));
	        bot.clear();
	    }
	    for(int i=0;i<(allFrames.size()-1);i++){
	        Vector thisFrame = (Vector)allFrames.get(i);
	        Hashtable currentScores = new Hashtable();
	        for(int j=0;j<thisFrame.size();j++){
                NanoBit bit = (NanoBit)thisFrame.get(j);
                PlayerToken owner = (PlayerToken)playerLookup.get(bit.id);
                
                if (currentScores.get(owner)==null){
                    currentScores.put(owner,new Integer(0));
                }
                int runningScore = ((Integer)currentScores.get(owner)).intValue(); 
                currentScores.put(owner,new Integer(runningScore+bit.munched));
            }
	        Iterator siterator = currentScores.keySet().iterator();
	        while(siterator.hasNext()){
	            PlayerToken who = (PlayerToken)siterator.next();
	            //System.out.println("Who is "+who);
	            PlayerEvent e = new PlayerEvent();
	            e.player = who;
	            e.disqualified=false;
	            e.leader=false;
	            e.score = ((Integer)currentScores.get(who)).intValue();
	            e.validMove = true;//might not be necessary
	            playerSpeaker.announcePlayerMoved(e);
	            playerSpeaker.announcePlayerStatusChanged(e);
	        }
	        synchronized (nanoLookup){
	            //nanoPlacesStart.clear();
	            //nanoPlacesEnd.clear();
	            for(int j=0;j<thisFrame.size();j++){
	                NanoBit bit = (NanoBit)thisFrame.get(j);
	                KNanoBot bot = (KNanoBot)nanoLookup.get(bit.id);
	                nanoPlacesStart.put(bit.id,bit.spot);
	                //int spotIndex = edgeLookup.indexOf(bit.spot);
	                //eaten[spotIndex] = (PlayerToken)playerLookup.get(bit.id);
	            }
	            Vector nextFrame = (Vector)allFrames.get(i+1);
	            for(int j=0;j<nextFrame.size();j++){
	                NanoBit bit = (NanoBit)nextFrame.get(j);
	                KNanoBot bot = (KNanoBot)nanoLookup.get(bit.id);
	                nanoPlacesEnd.put(bit.id,bit.spot);
	                //int spotIndex = edgeLookup.indexOf(bit.spot);
	                //eaten[spotIndex] = (PlayerToken)playerLookup.get(bit.id);
	            }
	            Set s = nanoLookup.keySet();
	            Iterator edges = s.iterator();
	            while (edges.hasNext()){
	                Integer id = (Integer)edges.next();
	                KNode a = (KNode)nanoPlacesEnd.get(id);
	                KNode b = (KNode)nanoPlacesStart.get(id);
	                if (a==null || b==null){
	                    continue;
	                }
	                if (a.getPoint().equals(b.getPoint())){
	                    continue;
	                }
	                KEdge[] gEdges =graph.getUniqueEdges(); 
	                for(int e=0;e<gEdges.length;e++){
	                    if (gEdges[e].doesContain(a) &&gEdges[e].doesContain(b)){
	                        eaten[e] = (PlayerToken)playerLookup.get(id);
	                    }
	                }
	            }
	            currentScores = new Hashtable();
		        for(int j=0;j<nextFrame.size();j++){
	                NanoBit bit = (NanoBit)nextFrame.get(j);
	                PlayerToken owner = (PlayerToken)playerLookup.get(bit.id);
	                
	                if (currentScores.get(owner)==null){
	                    currentScores.put(owner,new Integer(0));
	                }
	                int runningScore = ((Integer)currentScores.get(owner)).intValue(); 
	                currentScores.put(owner,new Integer(runningScore+bit.munched));
	            }
		        siterator = currentScores.keySet().iterator();
		        while(siterator.hasNext()){
		            PlayerToken who = (PlayerToken)siterator.next();
		            //System.out.println("Who is "+who);
		            PlayerEvent e = new PlayerEvent();
		            e.player = who;
		            e.disqualified=false;
		            e.leader=false;
		            e.score = ((Integer)currentScores.get(who)).intValue();
		            e.validMove = true;//might not be necessary
		            playerSpeaker.announcePlayerMoved(e);
		            playerSpeaker.announcePlayerStatusChanged(e);
		        }
		        while(currentPosition <= 1.0){
		            try {
		                //repaint();
		                update(this.getGraphics());
		                currentPosition += interpolation;
		                Thread.sleep(100);
		                
		            } catch (InterruptedException e){
		            
		            }
		        }
		        //Report scores here.
	        }
	        currentPosition = 0;
	    }
	}
    public NanoSimulation(PlayerColors pc,PlayerBroadcaster playerSpeaker){
	    this.playerSpeaker = playerSpeaker;
        playerColors = pc;
        /*Thread paintThread = new Thread(){
            public void run(){
                while(true){
                try {
                    repaint();
                    Thread.sleep(100);
                }catch (InterruptedException e){
                    
                }
                
                }
            }
        };
        paintThread.start();*/
    }
    public void update(Graphics g){
        if (graph==null){
            return;
        }
        int width = getWidth();
        int height = getHeight();
        if (offscreen == null || (width != lastWidth) || (height != lastHeight)) {
			offscreen = createImage(width, height);
			bufferGraphics = offscreen.getGraphics();
		}
        lastWidth = width;
        lastHeight = height;
        bufferGraphics.setColor(Color.black); //getBackground());
		bufferGraphics.fillRect(0, 0, width, height);
        
        //g.translate(0,-1);
        woffset = width/(graph.getWidth()+1);
        hoffset = height/(graph.getHeight()+1);
        bufferGraphics.setColor(new Color(0,0,0));
        if (((width+1) > graph.getWidth()) && ((height+1) > graph.getHeight())){
            KEdge[] edges = graph.getUniqueEdges();
            int sx,sy,dx,dy;
            for(int i=0;i<edges.length;i++){
                if (eaten[i]==null){
                    bufferGraphics.setColor(Color.gray);
                }else{
                    bufferGraphics.setColor(playerColors.getColor(eaten[i]));
                }
                    sx = woffset + woffset*edges[i].getNodes()[0].getX();
                    dx = woffset + woffset*edges[i].getNodes()[1].getX();
                    sy = hoffset + hoffset*edges[i].getNodes()[0].getY();
                    dy = hoffset + hoffset*edges[i].getNodes()[1].getY();
                    
                    bufferGraphics.drawLine(sx,sy,dx,dy);
                    
                    if (eaten[i]!=null){
                        bufferGraphics.drawLine(sx,sy+1,dx,dy+1);
                        bufferGraphics.drawLine(sx+1,sy,dx+1,dy);
                        bufferGraphics.drawLine(sx,sy-1,dx,dy-1);
                        bufferGraphics.drawLine(sx-1,sy,dx-1,dy);
                        bufferGraphics.drawOval(sx-5,sy-5,10,10);
                        bufferGraphics.drawOval(dx-5,dy-5,10,10);
                    }
                    
                
            }
            //draw the bots
            for(int i=0;i<nanoPlacesStart.size();i++){
                
                Integer id = new Integer(i);
                KNode start = (KNode)nanoPlacesStart.get(id);
                KNode end =   (KNode)nanoPlacesEnd.get(id);
                
                if (end==null){
                    end = start;
                }
                sx = woffset + woffset*start.getX();
                dx = woffset + woffset*end.getX();
                sy = hoffset + hoffset*start.getY();
                dy = hoffset + hoffset*end.getY();
                
                int ix = (int)((double)sx + ((double)(dx - sx))*currentPosition);
                int iy = (int)((double)sy + ((double)(dy - sy))*currentPosition);
                PlayerToken thisOwner = (PlayerToken)playerLookup.get(id);
                bufferGraphics.setColor(playerColors.getColor(thisOwner));
                KNanoBot bot = (KNanoBot)nanoLookup.get(id);
                if (sx!=dx || sy!=dy){
                    bufferGraphics.fill3DRect(ix-10,iy-10,20,20,true);
                }else{
                    bufferGraphics.fill3DRect(ix-10,iy-10,20,20,false);
                }
                bufferGraphics.setColor(Color.white);
                 
                bufferGraphics.fillOval(dx-5,dy-5,10,10);
                bufferGraphics.setColor(Color.gray);
                bufferGraphics.fillRect(dx,dy+5,30,10);
                bufferGraphics.fillRect(dx,dy-15,30,10);
                bufferGraphics.setColor(Color.white);
                bufferGraphics.drawString(bot.getCode(),dx,dy+15);
                
                bufferGraphics.drawString(thisOwner.getName(),dx+1,dy-5);
            }
        }
        //g.translate(0,1);
        g.drawImage(offscreen, 0, 0, this);
    }
    public static void main(String args[]){
        final Frame f = new Frame("NanoSimulation");
        f.setLayout(new java.awt.BorderLayout());
        GraphEditPanel gep = new GraphEditPanel();
        gep.setSize(500,350);
        f.add(gep);
        
        f.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                f.dispose();
                System.exit(1);
            }
        });
        f.pack();
        f.show();
    }
    
    class NanoBit{
        public Integer id;
        public KNode spot;
        public boolean dead;
        public int munched;
    }
}
