package nanomunchers.bot;

import nanomunchers.graph.KNode;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *  
 */
public class KNanoBot {
    protected final static int UP = 3;

    protected final static int LEFT = 2;

    protected final static int DOWN = 1;

    protected final static int RIGHT = 0;

    protected int nodesMunched;

    protected boolean alive;

    protected int cycle;
    protected int deltaPosition;//Extra added to instruction pointer

    protected int[] instructionOrder;

    protected KNode startPosition;

    protected KNode location;

    public KNanoBot(String instOrder, KNode start) {
        location = start;
        startPosition = start;
        String[] parts = instOrder.split(" ");
        instructionOrder = new int[parts.length];
        alive = true;
        nodesMunched = 0;
        for (int i = 0; i < parts.length; i++) {
            parts[i] = parts[i].toUpperCase();
            if (parts[i].equals("U")) {
                instructionOrder[i] = UP;
            } else if (parts[i].equals("D")) {
                instructionOrder[i] = DOWN;
            } else if (parts[i].equals("L")) {
                instructionOrder[i] = LEFT;
            } else if (parts[i].equals("R")) {
                instructionOrder[i] = RIGHT;
            }
        }

    }

    public synchronized KNode nextMove() {
        int position = instructionOrder[cycle % instructionOrder.length];
        KNode[] others = location.getNeighbors();
        location.mark();

        boolean shouldDie = true;
        //boxed into a place
        for (int i = 0; i < others.length; i++) {
            shouldDie = shouldDie && others[i].isMarked();
        }
        if (shouldDie || others.length == 0) {
            System.out.println("DEAD Boxed in");
            alive = false;
            return null;
        }
        int destX = location.getX();
        int destY = location.getY();
        switch (position) {
        case UP:
            destY--;
            break;
        case DOWN:
            destY++;
            break;
        case LEFT:
            destX--;
            break;
        case RIGHT:
            destY++;
            break;
        }
        int chosen = -1;
        deltaPosition = 0;
        for (deltaPosition = 0; deltaPosition < instructionOrder.length; deltaPosition++) {
            destX = location.getX();
            destY = location.getY();
            switch ((position + deltaPosition) % instructionOrder.length) {
            case UP:
                destY--;
                break;
            case DOWN:
                destY++;
                break;
            case LEFT:
                destX--;
                break;
            case RIGHT:
                destY++;
                break;
            }
            for (int i = 0; i < others.length; i++) {
                if (others[i].isMarked() == false) {
                    if (others[i].getX() == destX && others[i].getY() == destY) {
                        chosen = i;
                        break;
                    }
                }
            }
            if (chosen != -1){
                break;
            }
        }
        
        if (chosen != -1) {
            System.out.println("Picked "+others[chosen] + " "+ others[chosen].isMarked());
            return others[chosen];
        }
        System.out.println("DEAD Boxed in");
        alive = false;
        return null;
        //return location;
    }

    public void move() {
        KNode home = nextMove();
        if (alive && home != null){
            home.mark();
            location = home;
        }
        cycle+= 1+deltaPosition;
    }

    public int getDirection() {
        return instructionOrder[cycle % instructionOrder.length];
    }

    public int getNodesMunched() {
        return nodesMunched;
    }

    public boolean isAlive() {
        return alive;
    }

    public void kill() {
        alive = false;
    }

    public void clear() {
        location = startPosition;
        nodesMunched = 0;
        alive = true;
    }

    public KNode getCurrentLocation() {
        return location;
    }
}