package heurgame.event;

/**
 * @author David Kaplin
 *
 * Should encompass events that all players and other entities should know
 * about the status and state of the game.
 */
public interface GameListener {
    /**
     * Called when the Game is being setup before the first turn is allowed.
     * @param e May have some specific setup information
     */
    abstract public void gameSetup(GameEvent e);
    /**
     * Called once the game is started and all the players are ready.
     * @param e additional information
     */
    abstract public void gameStarted(GameEvent e);
    /**
     * Called when the game is over.
     * @param e additional information
     */
    abstract public void gameEnded(GameEvent e);
}
