package heurgame;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Vector;

import heurgame.event.GameEvent;
import heurgame.event.TimeBroadcaster;
import heurgame.logging.LogBox;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class DefaultReferee extends Referee{
    protected LogBox debugging = new LogBox("Default Referee",new heurgame.ui.GraphicalLogInterface());
    protected Vector playerProxies = new Vector();
    protected HashMap playerMap = new HashMap();
    protected HashMap timeMap = new HashMap();
    protected TimeBroadcaster timeBroadcaster;
    protected Game game;
    /** 
     * @see heurgame.Referee#addPlayer(heurgame.PlayerProxy)
     */
    public void addPlayer(PlayerProxy p){
        playerProxies.add(p);
        playerMap.put(p.getToken(),p);
        debugging.addEntry("Player Joined",p.getToken().getName()+" from "+ p.getToken().getOrigin()+" has been added to the game.");
    }
    
    /** 
     * @see heurgame.Referee#warnPlayer(heurgame.PlayerToken, java.lang.String)
     */
    public void warnPlayer(PlayerToken offender, String mesg) {
        PlayerProxy proxy = (PlayerProxy)playerMap.get(offender);
        proxy.sendWarning(mesg);
        game.announcePlayerLeft(proxy.getToken());
    }
    public void disqualifyPlayer(PlayerToken offender, String why){
        PlayerProxy proxy = (PlayerProxy)playerMap.get(offender);
        proxy.sendDisqualify(why);
        game.announceDisqualification(offender);
        TimeKeeper t = (TimeKeeper)timeMap.get(offender);
        if (t!=null){
            t.stop();
            timeMap.remove(offender);
        }
        playerMap.remove(offender);
        
        playerProxies.remove(proxy);
        debugging.addEntry("Reject","Player "+offender.getName()+" has been removed.");
    }
    /** 
     * @see heurgame.Referee#rejectPlayer(heurgame.PlayerToken)
     */
    public void rejectPlayer(PlayerToken offender,String why) {
        PlayerProxy proxy = (PlayerProxy)playerMap.get(offender);
        proxy.sendDisqualify(why);
        game.announcePlayerLeft(offender);
        TimeKeeper t = (TimeKeeper)timeMap.get(offender);
        if (t!=null){
            t.stop();
            timeMap.remove(offender);
        }
        playerMap.remove(offender);
        
        playerProxies.remove(proxy);
        debugging.addEntry("Reject","Player "+offender.getName()+" has been removed.");
    }

    /** 
     * @see heurgame.Referee#rejectAllPlayers()
     */
    public void rejectAllPlayers(String why) {
        ListIterator p = playerProxies.listIterator();
        while(p.hasNext()){
            PlayerProxy proxy = (PlayerProxy)p.next();
            proxy.sendDisqualify(why);
            game.announcePlayerLeft(proxy.getToken());
            TimeKeeper t = (TimeKeeper)timeMap.get(proxy.getToken());
            if (t!=null){
                t.stop();
            }
        }
        playerProxies.clear();
        playerMap.clear();
        timeMap.clear();
        debugging.addEntry("Reject All","Players are cleared.");
    }

    /** 
     * @see heurgame.Referee#reportStatus(heurgame.PlayerToken)
     */
    public synchronized void reportStatus(PlayerToken uninformed){
        ListIterator p = playerProxies.listIterator();
        debugging.addEntry("Sending Status",game.getState());
        while(p.hasNext()){
            PlayerProxy proxy = (PlayerProxy)p.next();
            if (proxy.getToken() != uninformed){
                proxy.sendStatus(game.getState());
            }
        }
    }
    /** 
     * @see heurgame.Referee#reportIncrementalStatus()
     */
    public synchronized void reportIncrementalStatus(){
        ListIterator p = playerProxies.listIterator();
        debugging.addEntry("Sending Incremental Status",game.getIncrementalState());
        while(p.hasNext()){
            PlayerProxy proxy = (PlayerProxy)p.next();
                proxy.sendIncrementalStatus(game.getIncrementalState());
        }
    }

    public void setup(GameEvent e){
        game = e.context;
        timeBroadcaster = game.getTimeBroadcaster();
        timeMap = new HashMap();
        for(int i=0;i<playerProxies.size();i++){
            PlayerToken t = ((PlayerProxy)playerProxies.get(i)).getToken();
            TimeKeeper timeKeep =new TimeKeeper(timeBroadcaster,
					 t,
					 this,
					 game.getMaximumNormalTime(),
					 game.getMaximumWarningTime()); 
            timeMap.put(t,timeKeep);
            Thread timeRunner = new Thread(timeKeep);
            timeRunner.start();
        }
        
    }
}
