##Sample implementation of the
##Nanomunchers Client
##This time 2 Random clients
##
##David Kaplin
##Fall 2004 Heuristics

import socket
import random
import threading
import time

##Reads a chunk, 8KB at maximum of the socket stream
##Returns a list of non-empty stripped lines
def readlines(connection):
    buffer = connection.recv(8*1024)
    lines = buffer.split("\n")
    lines = map(str.strip,lines)
    lines = filter(lambda x: len(x) > 0,lines)
    return lines

def connect(server,port):
    sock = socket.socket (socket.AF_INET, socket.SOCK_STREAM)
    sock.connect((server,port))
    return sock

class RandomComp (threading.Thread):
    def __init__(self,sock,name):
        threading.Thread.__init__(self)
        self.player_name = name
        self.game_ended = False
        self.nodes = []
        self.edges = []
        self.width = 0
        self.height = 0
        self.num_munchers = 0
        self.num_nodes = 0
        self.num_edges = 0
        self.state = "GENERAL"
        self.sock = sock
        return
        
    def handle_init(self,protocol_args):
        self.width = int(protocol_args[0])
        self.height = int(protocol_args[1])
        self.num_munchers = int(protocol_args[2])
        return

    def handle_next(self,protocol_args):
        self.execute_random_move()
        return
    
    def handle_done(self,protocol_args):
        #Do Nothing
        return
    
    def handle_final(self,protocol_args):
        self.game_ended = True
        self.sock.close()
        print self.player_name," final ",protocol_args
        return

    def handle_move(self,protocol_args):
        gridtype = protocol_args[0]
        if gridtype == "WHOLEGRID":
            node_count = 0;
            for h in range(0,self.height):
                for w in range(0,self.width):
                    node = (node_count,w,h)
                    node_count = node_count + 1
                    self.nodes.append(node)
            self.execute_random_move()
        else:
            self.num_nodes = int(protocol_args[1])
            self.state = "NODE_PARSE"
            #We have more work to do before answering
        return

    def execute_random_move(self):
        #self.sock.send(str(x)+" "+str(y)+"\n")
        node_start = random.choice(self.nodes)
        nid,x,y = node_start
        instruction_order = ['U','D','L','R']
        random.shuffle(instruction_order);
        instructions = " ".join(instruction_order)
        send_string = str(x)+ " " + str(y)+" "+ instructions+"\n"
        print self.player_name,"sending",send_string
        self.sock.send(send_string)
        return
    
    def handle_bad_move(self,protocol_args):
        self.execute_random_move()
        return

    def handle_warning(self,protocol_args):
        print self.player_name,"I was warned",protocol_args
        return

    def handle_disqualified(self,protocol_args):
        #print protocol_args
        self.game_ended = True
        self.sock.close()
        print self.player_name,"I was disqualified",protocol_args
        return

    def run(self):
        self.sock.send(self.player_name+"\n")
        while self.game_ended == False:
            time.sleep(1.8)
            self.handle_protocol()
        return
        
    def handle_protocol(self):
        lines = readlines(self.sock)
        handlers = {}
        handlers['INIT'] = self.handle_init
        handlers['FINAL'] = self.handle_final
        handlers['MOVE'] = self.handle_move
        handlers['NEXT'] = self.handle_next
        handlers['DONE'] = self.handle_done
        handlers['INVALID'] = self.handle_bad_move
        handlers['OUTTAHERE'] = self.handle_disqualified
        handlers['WARNING'] = self.handle_warning
        for line in lines:
            if len(line) == 0:
                continue
            chunked = line.split(" ")
            print self.player_name," got raw: ",line
            if self.state == "GENERAL":
                command = chunked[0]
                arguments = chunked[1:]
                handlers[command](arguments)
            elif self.state == "NODE_PARSE":
                if chunked[0] == "EDGES":
                    self.state = "EDGE_PARSE";
                    self.num_edges = int(chunked[1])
                else:
                    node = int(chunked[0]),int(chunked[1]),int(chunked[2])
                    self.nodes.append(node);
            else :
                #self.state = "EDGE_PARSE" is the only other possibility
                edge = int(chunked[0]),int(chunked[1])
                self.edges.append(edge)
                if len(self.edges) == self.num_edges:
                    self.execute_random_move()
                    self.state = "GENERAL"
                
        return self.game_ended;
    
    
if __name__ == '__main__':
    allnames = ['bunny','cow','chicken','fly','gnat','wolf','penguin','killa','duck','rhino','mosquito','rat','bison']
    names = []
    num_players = 3 #len(allnames)
    for i in range(0,num_players):    
        names.append(random.choice(allnames))
        allnames.remove(names[i])
    for i in names:
        a = RandomComp(connect('localhost',20000),i)
        a.start()
