package nanomunchers.graph;
/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 * Represents an Edge in a graph
 */
public class KEdge {
    protected KNode sideOne;
    protected KNode sideTwo;

    public KEdge(KNode sOne, KNode sTwo){
        sideOne = sOne;
        sideTwo = sTwo;
    }
    public boolean isNeighbor(KEdge e){
        return doesContain(e.sideOne) || doesContain(e.sideTwo);
    }
    public boolean doesContain(KNode n){
        return (n.getId()==sideOne.getId()) ||(n.getId()==sideTwo.getId());
    }
    public KNode getOther(KNode startingPoint){
        if (doesContain(startingPoint)==false){
            return null;
        }
        return (startingPoint.getId() == sideOne.getId()) ? sideTwo : sideOne;
    }
    public KNode[] getNodes(){
        return new KNode[]{sideOne,sideTwo};
    }
    public String toString(){
        return "" +sideOne + " " + sideTwo;
    }
}
