package nanomunchers;
import java.io.*;
import java.util.*;

import nanomunchers.bot.NanoBot;
import nanomunchers.graph.Graph;
import nanomunchers.graph.Node;
import nanomunchers.graph.NodeSet;
import nanomunchers.ui.GraphPanel;

/*
 * Created on Oct 24, 2003
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */

/**
 * @author john doe
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class VoodooNano {
	
	/*
	 *  Useful utility functions for reading boards and solutions
	 */

	long runTime = 60 * 1000 * 5;
	long endTime = -1;
	long currentTime = -1;

	Graph graph = new Graph();

	public int SCORE = Integer.MAX_VALUE;

	static final int NODES = 1;
	static final int EDGES = 2;

	private String fileName = "";

	/**
	 * 
	 */
	public VoodooNano() {
	}

	public void init(String s) {

		currentTime = System.currentTimeMillis();
		endTime = currentTime + runTime;

		fileName = s;

		System.out.println(
			"time started:= " + currentTime + "...reading file '" + s + "'");

		try {
			File f = new File(s);

			BufferedReader reader = new BufferedReader(new FileReader(f));
			String line = null;
			int mode = NODES;
			while ((line = reader.readLine()) != null) {

				if ("".equals(line.trim())) {
					continue;
				}
				if (line.startsWith("node")) {
					mode = NODES;
					continue;
				}
				if (line.startsWith("edge")) {
					mode = EDGES;
					continue;
				}

				switch (mode) {

					case NODES :
						graph.addNode(VoodooNano.makeNode(line));
						break;
					case EDGES :
						addEdge(graph, line);
						break;
				}
			}
			graph.initEdges();
			NodeSet[] sets = graph.makeSets();

			for (int i = 0; i < sets.length; i++) {
				graph.addSet(sets[i]);
			}

			System.out.println("number of NodeSets" + graph.getNodeSetSize());

		} catch (Exception e) {
			System.out.println(" errors reading file ");
			e.printStackTrace();
		}

	}

	public static void readNodes(Graph graph, String s) {

		int mode = 0;
		StringTokenizer st = new StringTokenizer(s);
		while (st.hasMoreTokens()) {

			String line = st.nextToken();

			if ("".equals(line.trim())) {
				continue;
			}
			if (line.startsWith("node")) {
				mode = NODES;
				continue;
			}
			if (line.startsWith("edge")) {

				mode = EDGES;
				continue;
			}

			switch (mode) {

				case NODES :

					graph.addNode(makeNode(line));
					break;
				case EDGES :
					addEdge(graph, line);
					break;
			}
		}

		graph.initEdges();
	}

	public static NodeSet readSolution(Graph g, String s) {
		System.out.println("voodooNano:  reading solution");

		NodeSet set = new NodeSet();

		for (int i = 0, c = g.getNodeSize(); i < c; i++) {
			set.addNode(g.getNode(i));
		}

		StringTokenizer st = new StringTokenizer(s);

		while (st.hasMoreTokens()) {

			String token = st.nextToken();
			set.addBot(makeBot(g, token));
		}
		System.out.println("voodooNano:  finished reading solution");
		return set;
	}

	public static String randomBoard() {

		NodeSet set = new NodeSet();
		int count = 0;

		for (int w = 0, c = 20; w < c; w++) {

			for (int h = 0, k = 10; h < k; h++) {

				int ri = Math.abs(r.nextInt());
				//System.out.println ( ri + "  " + ri % 2);
				if (ri % 2 == 1) {

					Node n = new Node(count, w, h);
					count++;
					set.addNode(n);
				}
			}
		}

		for (int w = 0, c = 19; w < c; w++) {

			for (int h = 0, k = 10; h < k; h++) {

				Node n = set.getNode(w, h);
				Node n2 = set.getNode(w + 1, h);
				if (n != null && n2 != null && r.nextInt() % 5 < 4) {
					set.addEdge(n.getId(), n2.getId());
				}
			}
		}

		for (int w = 0, c = 20; w < c; w++) {

			for (int h = 0, k = 9; h < k; h++) {

				Node n = set.getNode(w, h);
				Node n2 = set.getNode(w, h + 1);
				if (n != null && n2 != null && r.nextInt() % 5 < 4) {
					set.addEdge(n.getId(), n2.getId());
				}
			}
		}

		return set.toString();
	}

	public static NanoBot makeBot(Graph g, String s) {

		StringTokenizer st = new StringTokenizer(s, ",");

		return new NanoBot(
			st.nextToken(),
			g.getNode(Integer.parseInt(st.nextToken())),
			st.nextToken(),
			st.nextToken(),
			st.nextToken(),
			st.nextToken());
	}

	public static Node makeNode(String s) {
		StringTokenizer st = new StringTokenizer(s, ", ");

		return new Node(
			Integer.parseInt(st.nextToken()),
			Integer.parseInt(st.nextToken()),
			Integer.parseInt(st.nextToken()));

	}

	public static void addEdge(Graph graph, String s) {

		StringTokenizer st = new StringTokenizer(s, ", ");
		graph.addEdge(
			Integer.parseInt(st.nextToken()),
			Integer.parseInt(st.nextToken()));

	}

	public GraphPanel panel = null;

	public static String arrayString(Object[] r) {
		String s = "";
		for (int i = 0; i < r.length; i++) {
			s += " [ " + r[i].toString() + "] ";
		}
		return s;
	}

	//////////////

	///////////////

	public static void main(String[] args) {
		System.out.println(args);
		VoodooNano nano = new VoodooNano();
		System.out.println("arg1= fileName arg2= runTime ");
		nano.runTime = Integer.parseInt(args[0]) * 60 * 1000;
		nano.init(args[1]);
		//nano.run();
		System.out.println("end trans.");
	}

	public static Random r = new Random(System.currentTimeMillis());
}
