package nanomunchers;

import java.util.Vector;

import nanomunchers.bot.NanoBot;
import nanomunchers.bot.NanoBotWrangler;
import nanomunchers.graph.Graph;
import nanomunchers.ui.NanoSimulation;
import heurgame.PlayerToken;
import heurgame.analysis.MoveAnalyzer;
import heurgame.analysis.SystemAnalyzer;
/*
 * Created on Oct 27, 2004
 */

/**
 * Ensures legal moves and runs the simulation the first time.
 * 
 * @author David Kaplin
 */
public class NanoSystemAnalyzer implements SystemAnalyzer {
    private Graph board;
    private NanoBotWrangler nanoManager;
    private NanoSimulator nanoSimulator;
    private NanoSimulation uiNanoSim;
    private Vector simulationResults;
    private Vector playerTokens;
    private NanoMoveAnalyzer moveAnalyzer;
    private int maxPlayerBots;
    
    /**
     * @return related to the game
     */
    public Graph getBoard(){
        return board;
    }
    /**
     * Ensures everyone plays with the correct number of nanomunchers.
     * 
     * @param owner in question
     * @return true if the owner has not placed the required number
     * of nanobots.
     */
    public boolean needMore(PlayerToken owner){
        Vector existingBots = nanoManager.getNanoBots(owner);
        int numBots = existingBots.size();
        if (numBots == maxPlayerBots){
            return false;
        }
        return true;
    }
    /**
     * Used to get a response about error conditions.
     * 
     * @param owner in question
     * @param newBot in question
     * @return a variety of error conditions.
     */
    public synchronized String getResponse(PlayerToken owner, NanoBot newBot){
        String response = "";
        synchronized (nanoManager){
        Vector existingBots = nanoManager.getNanoBots(owner);
        int numBots = existingBots.size();
        
        if (numBots == maxPlayerBots){
            response = "Too many bots";
            return response;
        }
        //attempt to add it
        boolean addResult = nanoManager.addNanoBot(owner,newBot);
        if (addResult == false){
            response = "DUPLICATE";
        }else{
            numBots++;
            System.out.println(owner.getName()+" BOTS: "+numBots+" MAX "+ maxPlayerBots);
            if (numBots == maxPlayerBots){
                System.out.println(owner.getName()+"Sys says done");
                return "DONE";
            }else{
                return "NEXT";
            }
        }
        return response;
        }
    }
    /**
     * Initalizes objects related to the system as a whole.
     * 
     * @param maxBots desired allocation of nanomunchers per player
     * @param nanoField where the game will be played.
     * @param ui to be associated with the simulator.
     */
    public void setup(int maxBots,Graph nanoField, NanoSimulation ui){
        moveAnalyzer = new NanoMoveAnalyzer();
        moveAnalyzer.setSystemContext(this);
        maxPlayerBots = maxBots;
        board = nanoField;
        nanoManager = new NanoBotWrangler();
        uiNanoSim = ui;
    }
    /**
     * @param playerTokens players to be used in the simulation
     */
    public void runSimulation(Vector playerTokens){
        this.playerTokens = playerTokens;
        nanoSimulator = new NanoSimulator(uiNanoSim, board, nanoManager, playerTokens);
        nanoSimulator.prepareSimulation();
        simulationResults = nanoSimulator.feedSimulation();
        uiNanoSim.setSimulationSpeed(4.0);
        uiNanoSim.play();
    }
    /** 
     * @see heurgame.analysis.SystemAnalyzer#isGameOver()
     */
    public boolean isGameOver() {
        return simulationResults != null;
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#isDecisive()
     */
    public boolean isDecisive() {
        int max = -1;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() > max){
                max = thisScore.intValue();
            }
        }
        int count = 0;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() == max){
                count++;
            }
        }
        return (count==1);
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getWinningPlayer()
     */
    public PlayerToken getWinningPlayer() {
        int max = -1;
        int ndx = -1;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() > max){
                max = thisScore.intValue();
                ndx = i;
            }
        }
        PlayerToken winner = (PlayerToken)playerTokens.get(ndx);
        System.out.println(winner.getName()+" wins with "+ max);
        return winner;
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getWinningPlayers()
     */
    public PlayerToken[] getWinningPlayers() {
        int max = -1;
        int ndx = -1;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() > max){
                max = thisScore.intValue();
                ndx = i;
            }
        }
        Vector returnPlayers = new Vector();
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() == max){
                returnPlayers.add(playerTokens.get(i)); 
            }
        }
        PlayerToken[] winners = new PlayerToken[returnPlayers.size()];
        for(int i=0;i<winners.length;i++){
            winners[i] = (PlayerToken) returnPlayers.get(i);
            System.out.println(winners[i].getName()+" wins with "+ max);
        }
        
        
        return winners;
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#newGame()
     */
    public void newGame() {
        // TODO Auto-generated method stub

    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getMoveAnalyzer()
     */
    public MoveAnalyzer getMoveAnalyzer() {
        return moveAnalyzer;
    }

}
