package nanomunchers.graph;
/*
 * Created on Oct 26, 2004
 */

/**
 * Represents an Edge in a graph
 * 
 * @author David Kaplin
 */
public class Edge {
    protected Node sideOne;
    protected Node sideTwo;

    public Edge(Node sOne, Node sTwo){
        sideOne = sOne;
        sideTwo = sTwo;
    }
    public boolean isNeighbor(Edge e){
        return doesContain(e.sideOne) || doesContain(e.sideTwo);
    }
    public boolean doesContain(Node n){
        return (n.getId()==sideOne.getId()) ||(n.getId()==sideTwo.getId());
    }
    /**
     * Examines the points that make up both edges as opposed to the
     * nodes that surround those points.
     * 
     * @param b to be compared.
     * @return if the endpoints one way or another match in both this edge and in b. 
     */
    public boolean equalsSpacially(Edge b){
        boolean oneWay =(sideOne.getPoint().equals(b.sideOne.getPoint()) 
                && sideTwo.getPoint().equals(b.sideTwo.getPoint()));
        boolean otherWay = (sideOne.getPoint().equals(b.sideTwo.getPoint()) 
                && sideTwo.getPoint().equals(sideOne.getPoint())); 
        return  oneWay || otherWay;
                
    }
    public Node getOther(Node startingPoint){
        if (doesContain(startingPoint)==false){
            return null;
        }
        return (startingPoint.getId() == sideOne.getId()) ? sideTwo : sideOne;
    }
    public Node[] getNodes(){
        return new Node[]{sideOne,sideTwo};
    }
    public String toString(){
        return "" +sideOne + " " + sideTwo;
    }
}
