package nanomunchers;

import java.awt.Point;

import nanomunchers.bot.NanoBot;
import nanomunchers.graph.Graph;
import nanomunchers.graph.Node;
import heurgame.PlayerToken;
import heurgame.analysis.MoveAnalyzer;
/*
 * Created on Oct 21, 2004
 */

/**
 * Evaulates a single move with the help of the SystemAnalyzer
 * 
 * @author David Kaplin
 */
public class NanoMoveAnalyzer extends MoveAnalyzer {
    private Graph bounds;
    
    /**
     * Evaulates a single move with the help of the SystemAnalyzer
     * Determines out of bound conditions on its own.
     *  
     * @see heurgame.analysis.MoveAnalyzer#evaluateMove(java.lang.String, heurgame.PlayerToken, long)
     */
    public String evaluateMove(String move, PlayerToken senderToken,
            long timeTaken) {
        if (move==null || move.length()<5){
            return MoveAnalyzer.MOVE_DISQUALIFIED+"Null Move";
        }
        NanoSystemAnalyzer parent = (NanoSystemAnalyzer)this.systemContext;
        bounds = parent.getBoard();
        String[] parts = move.split(" ");
        Point p = new Point(Integer.parseInt(parts[0]),
                            Integer.parseInt(parts[1]));
        String rest = parts[2]+" "+parts[3]+ " "+parts[4]+" "+parts[5];
        Node[] validPoints =bounds.getNodes();
        Node actualStartPoint = null;
        for(int i=0;i<validPoints.length;i++){
            Node thisPoint = validPoints[i];
            if (thisPoint.getPoint().equals(p)){
                actualStartPoint = thisPoint;
                break;
            }
        }
        if (actualStartPoint==null){
            return MoveAnalyzer.MOVE_INVALID+"OUTSIDE";
        }
        NanoBot bot = new NanoBot(rest, actualStartPoint);
        String systemResponse = parent.getResponse(senderToken,bot);
        if (systemResponse.equals("DUPLICATE") ||systemResponse.equals("Too many bots") ){ 
            return MoveAnalyzer.MOVE_INVALID+systemResponse;
        }
        return MoveAnalyzer.MOVE_VALID + systemResponse;
    }
}
