package nanomunchers.ui;
import java.awt.*;

import nanomunchers.bot.NanoBot;
import nanomunchers.graph.Graph;
import nanomunchers.graph.Node;
import nanomunchers.graph.NodeSet;

/*
 * Created on Oct 25, 2003
 *
 */

/**
 * @author john doe
 * 
 * GraphPanel is the visual component to the Graph
 * Renders all the nodes in a graph
  */
public class GraphPanel extends Panel {

	public static int REFRESH_RATE = 2200;

	Graphics bufferGraphics;
	Image offscreen;

	Color BLACK = new Color(0, 0, 0);
	Color DARK_GRAY = new Color(125, 125, 125);

	Graph graph = null;
	double scaleX = 40;
	double scaleY = 40;

	int SIZE = 8;
	int BORDER = 10;
	int x = 0;
	int y = 0;

	int pH, pW;

	public int WIDTH = 700;
	public int HEIGHT = 300;

	public Dimension getPreferredSize() {
		return new Dimension(WIDTH, HEIGHT);
	}

	public GraphPanel(Graph g) {
		super();
		graph = g;

		new Thread() {

			public void run() {
				while (true) {

					repaint();
					try {
						sleep(100);
					} catch (Exception e) {
					};
				}
			}
		}
		.start();
	}

	public void paint(Graphics g) {

		//	System.out.println( preferredSize() );


		if (offscreen == null) {
			offscreen = createImage(WIDTH, HEIGHT);
			bufferGraphics = offscreen.getGraphics();
			System.out.println("null");
		}

		try {

			//super.paint(bufferGraphics);

			bufferGraphics.setColor(Color.white); //getBackground());
			bufferGraphics.fillRect(0, 0, WIDTH, HEIGHT);

			if (graph.getNodeSize() == 0) {
				bufferGraphics.setColor(BLACK);
				bufferGraphics.drawLine(0, 0, WIDTH, HEIGHT);
				bufferGraphics.drawLine(WIDTH, 0, 0, HEIGHT);
			} else {

				bufferGraphics.setColor(Color.black);
				bufferGraphics.drawString(
					"Bots Alive ="
						+ graph.liveCount()
						+ " Nodes Left ="
						+ graph.nodesLeft(),
					2,
					10);
					
				if ( graph.getNodeSetSize() > 0 ) {
					NodeSet set = graph.getNodeSet(0);
					int time = set.time;
					String t = "";
					if ( time < 10 ) {
						t = " " + time;
					} else {
						t = "" + time;
					}
					bufferGraphics.drawString( "TIME =" + t, 200, 10 );
				}	
				
				bufferGraphics.translate(BORDER, BORDER);
				
				paintNodes(bufferGraphics);
				paintSet(bufferGraphics);
				bufferGraphics.translate(-BORDER, -BORDER);
			}
			Thread.yield();
		} catch (RuntimeException e) {
			bufferGraphics.translate(-BORDER, -BORDER);
			e.printStackTrace();
		} 

		g.drawImage(offscreen, 0, 0, this);

	}

	void paintSet(Graphics g) {

		g.setColor(BLACK);
		//g.drawString(sets[0].time + "", 0, 0);
		for (int i = 0, c = graph.getNodeSetSize(); i < c; i++) {

			NodeSet set = graph.getNodeSet(i);
			paintBots(set, g);
		}
	}

	public void update(Graphics g) {
		paint(g);
	}

	void paintBots(NodeSet set, Graphics g) {

		for (int i = 0, c = set.getBotSize(); i < c; i++) {

			NanoBot bot = set.getBot(i);
			//			Node node = bot.getNode();
			g.setColor(BLACK);

			Node startNode = bot.getStart();

			if (startNode != null) {
				g.setColor(bot.color);
				g.drawRect(
					(int) (startNode.getLoc().x * scaleX),
					(int) (startNode.getLoc().y * scaleY),
					SIZE,
					SIZE);

			}
			//		if (node != null) {
			paintBot(g, bot);
			/*	g.drawLine(
					(int) (bot.x * scale),
					(int) (bot.y * scale),
					bot.getStart().getLoc().x * scale,
					bot.getStart().getLoc().y * scale);
			*/
			//	}
		}

	}

	public void paintBot(Graphics g, NanoBot bot) {

		g.fill3DRect(
			(int) (bot.x * scaleX),
			(int) (bot.y * scaleY),
			SIZE,
			SIZE,
			true);

	}

	public Dimension preferredSize() {
		return new Dimension(300, 300);
	}

	public void reshape(int x, int y, int width, int height) {

		super.setBounds(x, y, width, height);

		BORDER = 1 + width / 10;
		//width = Math.min( width, height);
		scaleX = width / 25;
		scaleY = height / 15;
		pW = width;
		pH = height;

	}

	void paintNodes(Graphics g) {

		for (int i = 0, c = graph.getNodeSize(); i < c; i++) {
			paintNode(graph.getNode(i), g);
		}
	}

	void paintNode(Node n, Graphics g) {
		if (n.isMarked()) {

			if (n.getBot() != null) {
				g.setColor(n.getBot().color);
			} else {
				g.setColor(DARK_GRAY);
			}

			g.fillOval(
				(int) ((n.getLoc().x) * scaleX),
				(int) ((n.getLoc().y) * scaleY),
				SIZE,
				SIZE);
		} else {
			g.setColor(DARK_GRAY);
			g.drawOval(
				(int) ((n.getLoc().x) * scaleX),
				(int) ((n.getLoc().y) * scaleY),
				SIZE,
				SIZE);
		}

		paintEdges(n, g);
	}

	void paintEdges(Node n, Graphics g) {

		//g.setColor( DARK_GRAY );
		g.setColor(BLACK);
		for (int i = 0, c = NodeSet.MAX_EDGES; i < c; i++) {
			Node node = n.getEdge(i);
			if (node != null) {
				g.drawLine(
					(int) (n.getLoc().x * scaleX + SIZE / 2),
					(int) (n.getLoc().y * scaleY + SIZE / 2),
					(int) (node.getLoc().x * scaleX + SIZE / 2),
					(int) (node.getLoc().y * scaleY + SIZE / 2));
			}
		}
	}

	public static void main(String[] args) {
	}
}
