/*
 * Created on Oct 13, 2004
 */
package heurgame.logging;

/**
 * @author David Kaplin
 *
 * There will always be an occaision to dump the output of the log to standard
 * output.  This class allows just that.
 */
public class DebugLogReader implements LogReader {

	/** 
	 * Performs the actual printing
	 * @see heurgame.logging.LogReader#readLog(java.lang.String, int, heurgame.logging.LogItem)
	 */
	public void readLog(String who, int priority, LogItem information) {
		System.out.println(who +"["+information.priority+"] " +information.shortDescription );
		System.out.println(information.longDescription );
		System.out.println();
	}

	/** 
	 * Well this method doesn't do much because of the nature of
	 * screen output.
	 * 
	 * @see heurgame.logging.LogReader#clearLog()
	 */
	public void clearLog() {

	}

}
