package heurgame.logging;

/**
 * @author David Kaplin
 *
 * There is potential for the logging infrastructure to get too large
 * for a single class.  Through this different logs may be built for
 * a wide variety of uses.
 */
abstract public class AbstractLog {
    /**
     * Adds the LogWriter to its pickup.
     * Make sure to add your Readers first!
     * 
     * @param w The Specific Writer 
     */
    abstract public void addLogWriter(LogWriter w);
    /**
     * Adds the LogReader to its delivery
     * Always add your Readers first!
     * 
     * @param r to be added.
     */
    abstract public void addLogReader(LogReader r);
    
    /**
     * Should force a clear on all readers and set them back
     * to their initial states.
     */
    abstract public void clear();

    /**
     * Should initiate some sort of mechanism for both receiving log
     * entries and delivering them to the readers
     */
    abstract public void startLogging();
    
    /**
     * Terminates the mechanism for log input and output 
     */
    abstract public void stopLogging();
    
    /**
     * Removes the LogWriter from pickup.
     * 
     * @param w The Specific Writer 
     */
    abstract public void removeLogWriter(LogWriter w);

    /**
     * Removes the LogReader from delivery
     * 
     * @param r to be removed.
     */
    abstract public void removeLogReader(LogReader r);
}
