package heurgame.event;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class GameBroadcaster {
    public final static int GAME_START = 0;
    public final static int GAME_END = 1;
    public final static int GAME_SETUP = 2;
    
    protected List listeners;
    protected boolean simultaneous;
    public GameBroadcaster(){
        simultaneous = false;
        listeners = new Vector();
    }
    public GameBroadcaster(boolean simultaneous){
        this.simultaneous = simultaneous;
        listeners = new Vector();
    }
    public void addGameListener(GameListener g){
        if (listeners.contains(g)){
            return;
        }
        listeners.add(g);
    }
    public void removeGameListener(GameListener g){
        if (listeners.contains(g)){
            listeners.remove(g);
        }
    }
    public void announceSetup(GameEvent e){
        System.out.println("SETUP-----");
        if (simultaneous){
            simultaneousDispatch(e,GAME_SETUP);
            System.out.println("--------SETUP");
            return;
        }
        dispatch(e,GAME_SETUP);
        System.out.println("--------SETUP");
    }
    public void announceStart(GameEvent e){
        System.out.println("START-----");
        if (simultaneous){
            simultaneousDispatch(e,GAME_START);
            System.out.println("--------START");
            return;
        }
        dispatch(e,GAME_START);
        System.out.println("--------START");
    }
    public void announceEnd(GameEvent e){
        System.out.println("END-----");
        if (simultaneous){
            simultaneousDispatch(e,GAME_END);
            System.out.println("--------END");
            return;
        }
        dispatch(e,GAME_END);
        System.out.println("--------END");
    }
    protected void dispatch(GameEvent e,int kind){
        Iterator i = listeners.iterator();
        while(i.hasNext()){
            GameListener g = (GameListener)i.next();
            GameEventDispatcher hermes = new GameEventDispatcher(g,e,kind);
            hermes.run();
        }
    }
    protected void simultaneousDispatch(GameEvent e,int kind){
        Iterator i = listeners.iterator();
        while(i.hasNext()){
            GameListener g = (GameListener)i.next();
            Thread hermes = new Thread(new GameEventDispatcher(g,e,kind));
            hermes.start();
        }
    }
}

class GameEventDispatcher implements Runnable{
    private GameListener toGet;
    private GameEvent toSend;
    private int mode;
    GameEventDispatcher(GameListener target, GameEvent message, int type){
        toGet = target;
        toSend = message;
        mode = type;
        System.out.println("Contacting"+target.getClass());
    }
    /** 
     * @see java.lang.Runnable#run()
     */
    public void run() {
        switch (mode){
        	case GameBroadcaster.GAME_START:
        	    toGet.gameStarted(toSend);
        	    break;
        	case GameBroadcaster.GAME_END:
        	    toGet.gameEnded(toSend);
        	    break;
        	case GameBroadcaster.GAME_SETUP:
        	    toGet.gameSetup(toSend);
        	    break;
        }
    }
}