package heurgame;
/*
 * Created on Oct 12, 2004
 */

import heurgame.event.*;
/**
 * @author David Kaplin
 *
 * The referee is the middleman in any game.  He deals with both the 
 * high-level of the rules of the game and the low-level details of the
 * actual players.  The referee may or may not decide who stays or leaves
 * but it is his action that forces its execution.
 */
public abstract class Referee implements GameListener {
    /**
     * Adds a new player, should trigger the game to send a player
     * event.
     * 
     * @param p the new player attached to the game.
     */
    abstract public void addPlayer(PlayerProxy p);

    /**
     * There are occaisions usually time related where a player should be
     * warned.  A warning usually preceds a rejection.
     * @param offender to be warned
     */
    abstract public void warnPlayer(PlayerToken offender,String mesg);
    /**
     * Removes a player from the game because of an illegal move
     * 
     * @param offender player responsible
     * @param why		reason for disqualificication
     */
    abstract public void disqualifyPlayer(PlayerToken offender, String why);
    /**
     * Removes a single player from the game.
     * Their socket will be terminated.
     * 
     * @param offender to be removed
     */
    
    abstract public void rejectPlayer(PlayerToken offender,String why);
    /**
     * The quick way to force a game reset.
     */
    abstract public void rejectAllPlayers(String why);    
    /**
     * Reports the state of the game to all players execpt
     * a particular one
     * @param uninformed not told status
     */
    abstract public void reportStatus(PlayerToken uninformed);
    /**
     * Reports the latest change in the game to all players 
     */
    abstract public void reportIncrementalStatus();
}
