#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <assert.h>

int main (int argc, char **argv){
  FILE *file;
  char buffer[1024], ch;
  int length = 0;

  if (argc != 2){
    fprintf (stderr, "Usage:\n\ngetlength seqfile\n");
    exit (1);
  }

  file = fopen (argv[1], "r"); assert (file);
  fgets (buffer, 1024, file);
  while (!feof (file)){
    ch = fgetc (file);
    if (ch == '>') break;
    if (isalpha (ch) || ch == '.' || ch == '-') length++;
  }
  fclose (file);

  printf ("%d\n", length);
}










