#!/usr/bin/env perl

$lagandir = $ENV{LAGAN_DIR};
$lazyflag = 0;
$recurfl = "-recurse \"(12,0,25),(13,1,25),(8,1,30),(7,1,15)\"";
$anchgapstart = -0.1;
$anchgapcont = -0.01;
$usebounds = 1;
$window = 50;
$startingrate = 40;
$rateinc = 5;

print ("\n");
print ("Computing Contig Ordering\n");
print ("-------------------------\n\n");

$foundorder = 0;
for ($cutoff = $startingrate; !$foundorder && ($cutoff < 100); $cutoff += $rateinc){
    `$lagandir/utils/makeranges 2706.filenames ~/draft/LDLR/human.fasta $cutoff $rateinc > 2706.ranges`;

    `$lagandir/utils/contigorder 2706.ranges > 2706.corder`;
    @list = `cat 2706.corder`;
    chomp $list[0];
    if ($list[0] ne "ordering failed"){
	$foundorder = 1;
    }
}

for ($i = 0; $i < @filenames; $i++){
    for ($rate = $cutoff; $rate < 100; $rate += $rateinc){
	`rm $filenames[$i].$rate`;
    }
}

if ($foundorder){

    open (OFILE, ">2706.draft");
    print OFILE ("Draft Alignment\n");
    print OFILE ("---------------\n");
    
    @list = `cat 2706.corder`;
    for ($i = 0; $i < @list; $i++){
	$list[$i] =~ /(\d+) --\> \((\d+) (\d+)\) (\d+)/;
	print OFILE ("$filenames[$1] --> ($2 $3) $4\n");
    }
    close (OFILE);
    
    print `cat 2706.draft`;
}
else {
    print `Could not compute ordering.`;
}
