#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "skiplist.h"
#include "multial.h"
#include "filebuffer.h"

#define VER_NUM "0.1"

// Global variables

static int nested = 0;
static int postir = 0;
static int lazy = 0;
static int notree = 1;
static int verbose = 0;
static int numseqs = 0;
static int itertimes = 1;
static int cutoffmatch = 12;

static align *simaligns[MAX_SEQ];
static char* lagan_dir;

static int hptrcomp (const void *p1, const void *p2) {
  int i = ((hptr*)p1)->number;
  int j = ((hptr*)p2)->number;
  int it = ((hptr*)p1)->isstart;
  int jt = ((hptr*)p2)->isstart;
  if (i > j)
    return (1);
  if (i < j)
    return (-1);
  if (it)
    return -1;
  else 
    return 1;
}


void usage(void) {
  printf("mlagan seqfile_1 seqfile_2 [... seqfile_%d] [-parameters]\n\n",
	 MAX_SEQ);
  printf("-nested : runs improvement in a nested fashion\n");  
  printf("-postir : incorporates the final improvement phase\n");
  printf("-lazy : uses lazy mode\n");
  printf("-verbose : give verbose output\n");
  printf("-tree \"(...)\" : runs with given phylogenetic tree\n");
  printf("-match # (default: %d)\n", match);
  printf("-mismatch # (default: %d)\n", mismatch);
  printf("-gapstart # (default: %d)\n", gapstart);
  printf("-gapend # (default: %d)\n", gapend);
  printf("-gapcont # (default: %d)\n", gapcont);
  printf("-out \"filename\": outputs to filename\n");
  printf("-version : prints version info\n");
}


seq* readfile(FILE* input) {
  int seqstart=0;
  int seqend=0; 
  char* res = (char*) malloc(sizeof(char)*2);
  int ressize = 2, numread=1; //N at 1st letter
  char temp[256];
  seq* myseq = (seq*) malloc(sizeof(seq));
  char currchar;

  res[0] = 'N';
  if (feof(input))
    return 0;
  fgets(temp, 255, input);
  if (temp[0] != '>') {
    fprintf(stderr, "File is not in FASTA format!!\n");
    exit(1);
  }

  myseq->name = (char*) malloc((strlen(temp))*sizeof(char));
  strcpy(myseq->name, temp+1);
  *(strchr(myseq->name, '\n')) = 0;
  currchar = fgetc(input);
  while ((currchar != '>') && (currchar != EOF)) {
    if (!isspace(currchar)) {
      currchar = toupper(currchar);
      if (!strchr(alpha, currchar)) {
        fprintf(stderr, "Warning: %c converted to 'N'\n", currchar, alpha);
	currchar = 'N';
    }
      res[numread++] = currchar;
      if (numread >= ressize) {
        res=(char*)realloc(res, sizeof(char)*(ressize*=2));
      }
    }
    currchar = fgetc(input);
  }
  if (currchar == '>')
    ungetc(currchar, input);
  res[numread]=0;
  myseq->rptr = res;

  if (seqstart > 0) {
    res = &res[seqstart-1];
    res[seqend-seqstart+1] = 0;
    numread = seqend-seqstart+1;
  }

  myseq->lets = res;
  myseq->numlets = numread;
  //  printf("read: %d lets\n",numread);
  return myseq;
}


align* findAlignByName(align *aligns[], char *name) {
  int i=0;
  // printf("findAlignByName: %s\n", name);
  while(i<numseqs) {
    if (strcmp(aligns[i]->seqs[0]->name, name)==0) {
      //       fprintf(stderr, "alignment found for \"%s\": ", name);
      // ma printSeqsNames(aligns[i]);
      return(aligns[i]);
    }
    i++;
  }
  fprintf(stderr, "alignment not found for: %s", name);
  exit(2);
  return NULL;
}

int kk = 0;

void printHLL(hll *myres) {
  printf("into %d\n", ++kk);
  fflush(stdout);
  while(myres) {

    printf("(%d %d)=(%d %d) %f\n", 
	   myres->seq1start, myres->seq1end,
	   myres->seq2start, myres->seq2end, myres->score);    
    fflush(stdout);
    myres=myres->next;
  }
}

hll* getHLLFromNames(char *name1, char *name2) {
  FILE *ancfile;
  hll *myres = 0, *tt = 0;
  char buff[256];
  int i=0;

  //  printf("getHLLFromNames: %s, %s\n", name1, name2);

  sprintf(buff, "%s%s.anchors", name1, name2);
  ancfile=fopen(buff, "r");
  if(ancfile==NULL) {
    sprintf(buff, "%s%s.anchors", name2, name1);
    ancfile=fopen(buff, "r");
  } 
  if(ancfile==NULL) {
    fprintf(stderr, "anchor file not found for pair: %s, %s\n",
	   name1, name2);
    exit(2);
  } else {
    // printf("anchor file found: %s\n", buff);
  }

  while (!feof(ancfile)) {
    if (!fgets(buff, 256, ancfile)) {
      break;
    }
    tt = (hll*) malloc(sizeof(hll));
    sscanf(buff, "(%d %d)=(%d %d) %f", &tt->seq1start, &tt->seq1end,
           &tt->seq2start, &tt->seq2end, &tt->score);
    tt->next = myres;
    i++;
    myres = tt;
  }
  fprintf(stderr,"read %d anchs\n", i);

  //  printf("In getHLLFromNames: \n");
  //  printHLL(myres);

  return myres;
}


hll* createGetHLLFromAligns(align *a1, align *a2) {
  char buff[256];
  char *name1;
  char *name2;
  align* temp;
  hll* res;
  char flip = 0;
  //  printf("in crgEET: %s(%d) with %s(%d)\n", a1->seqs[0]->name, a1->index, a2->seqs[0]->name, a2->index);
  if (a1->index ==  a2-> index) {
    return 0;
  }
  if (a1->index > a2-> index) {
    flip = 1;
    temp = a1;
    a1 = a2;
    a2 = temp;
  }
  name1 = a1->seqs[0]->name;
  name2 = a2->seqs[0]->name;
  sprintf(buff, "%s/rechaos.pl %s %s -out %s%s.anchors %s\n",
          lagan_dir,
	  a1->seqs[0]->filename,
	  a2->seqs[0]->filename,
	  name1,
	  name2,
	  (lazy ? "-lazy" : ""));
  //  printf("\n%s", buff);
  system(buff);

  res = getHLLFromNames(name1, name2);
  if (flip) {
    swapHLL(res);
    //    printf("SWAPPING: %s with %s\n", name1, name2);
  }
  return res;
}


void printFASTASeq(FILE *outfile, seq *myseq) {
  int i;
  //  printf("kva\n");
  if (!outfile)
    outfile = stdout;

  fprintf(outfile, ">%s\n", myseq->name);
  //  printf("kva2\n");
  for(i=0; i<myseq->numlets; i++)
    fprintf(outfile, "%c", myseq->rptr[i]);
  //  printf("kva %d\n",i);
  fprintf(outfile, "\n");
  
  if (outfile!=stdout) fclose(outfile);
}


void checkSeqName(seq *s, char *seqname) {
  if (s) {
    if(!s->name) {
      if (!seqname) {
	s->name=(char*) malloc (4*sizeof(char));
	strcpy(s->name, "SEQ");
	s->filename=(char*) malloc (7*sizeof(char));
	strcpy(s->filename, "SEQ.fa");
      } else {
	s->name=(char*) malloc (strlen(seqname)*sizeof(char));
	strcpy(s->name, seqname);
	s->filename=(char*) malloc ((strlen(seqname)+3)*sizeof(char));
	sprintf(s->filename, "%s.fa", seqname);
      }
    }
    else {
      if(!s->filename) {
	s->filename=(char*) malloc ((strlen(seqname)+3)*sizeof(char));
	sprintf(s->filename, "%s.fa", seqname);
	// printf("filename: %s.fa", seqname);
      }
    
    }
  }
}

hll* createGetHLLFromSeqs(seq *s1, seq *s2) {
  FILE *outfile;
  char buff[256];

  if (s1 && s2) {
    checkSeqName(s1, "S1");
    checkSeqName(s2, "S2");

    outfile = fopen(s1->filename, "w");
    printFASTASeq(outfile, s1);
    outfile = fopen(s2->filename, "w");
    printFASTASeq(outfile, s2);
    
    sprintf(buff, "%s/rechaos.pl %s %s -out %s%s.anchors %s-chaos \"-nd 1\"\n",
            lagan_dir,
	    s1->filename,
	    s2->filename,
	    s1->name,
	    s2->name,
	    (lazy ? "-lazy" : ""));
    //    printf("\n%s", buff);
    system(buff);
  
    return(getHLLFromNames(s1->name, s2->name));
  }
  
  return(NULL);
}


hll* findBestChain(hptr* array, int arrsize) {
  sklst* skipper = makeSkLst();
  sle* help;
  int i;
  hll* t;
  for (i = 0; i < arrsize; i++) {
    if (array[i].isstart) {
      help = SLfind(skipper, array[i].myhll->seq2start);
      if (help->myelem) {
	array[i].myhll->bkptr = help->myelem;
	array[i].myhll->scoreSoFar = ((hll*)help->myelem)->scoreSoFar + array[i].myhll->score;
      }
      else {
	array[i].myhll->bkptr = 0;
	array[i].myhll->scoreSoFar = array[i].myhll->score;
      }
    }
    else {
      help = SLfind(skipper, array[i].myhll->seq2end);
      if (help->myelem && (array[i].myhll->scoreSoFar <= ((hll*)help->myelem)->scoreSoFar))
	continue;
      SLinsertAfter(skipper, help, array[i].myhll->seq2end, array[i].myhll);
      help = help->next[0];
      while (help->next[0] && 
	     ((hll*)help->myelem)->scoreSoFar >= ((hll*)help->next[0]->myelem)->scoreSoFar)
	SLremove(skipper, help->next[0]);
    }
  }
  t= (hll*)SLgetLast(skipper)->myelem;
  delSkLst(skipper);
  return t;
}


hll* remakeHLL(hll* bestPtr) { 
  int len;
  hll *res=0;
  hll *temp, *t2, *t3;
  int i, bestscore=-1;
  for (temp = bestPtr; temp; temp = temp->bkptr) {
    temp->next=res;
    temp->dirty = 1;
    res=temp;    
  }
  
  return res;
}


hll* reanchorHLL(hll* mylist) {

  hll *temp, *best, *t2;
  int numhits=0, i=0;
  hptr* myptrs;

  temp=mylist;
  while (temp) { numhits++; temp->dirty = 1; temp=temp->next; }

  myptrs = (hptr*) malloc (sizeof(hptr) * numhits *2);
  for (temp = mylist; temp; temp = temp->next) {
    myptrs[i].number  = temp->seq1start;
    myptrs[i].isstart = 1;
    myptrs[i].myhll = temp;
    myptrs[i+1].number  = temp->seq1end;
    myptrs[i+1].isstart = 0;
    myptrs[i+1].myhll = temp;
    i = i+2;
  }
  qsort(myptrs, numhits*2, sizeof(hptr), hptrcomp);
  best = findBestChain(myptrs, numhits*2);
  temp=best;
  while (temp) { temp->dirty = 0; temp=temp->bkptr; }
  temp=mylist;
  while (temp) { t2 = temp; temp=temp->next; if (t2->dirty) free(t2); }

  best = remakeHLL(best);
  //  printf("newbest\n");
  //  printHLL(best);
  free (myptrs);
  return best;
}


void orderAligns(align *a1, align *a2,
		 align **first, align **second,
		 int *index, int *hllindex) {
  int a1index, a2index;

  a1index = a1->index; 
  a2index = a2->index;
  
  if (a1index > a2index) {    
    *first = a2;
    *second = a1;
    *index = a2index;
    *hllindex = a1index;
  } else {
    *first = a1;
    *second = a2;
    *index = a1index;
    *hllindex = a2index;
  }
}


void doRemapHLLs(align *aligns[], align *uni, int *index, int hllindex) {
  int i, mapi, done=0;

  // take all hlls into first, and into the second and remap them

  for(mapi=*index; !done; mapi=hllindex)  {

    for (i=0; i<mapi; i++) {
      if (aligns[i]->hlls[mapi] != NULL) {
	// remap them into i
	aligns[i]->hlls[mapi] = remapHLLs(aligns[i]->hlls[mapi],
					  1, uni, 
					  (mapi!=*index));
      }
    }
    for (i=mapi+1; i<numseqs; i++) {
      if (aligns[mapi]->hlls[i] != NULL) {
	// remap them into first or second
	aligns[mapi]->hlls[i] = remapHLLs(aligns[mapi]->hlls[i],
					  0, uni,
					  (mapi!=*index));
      }
    }
    if (mapi==hllindex) done=1;
  }

  // free memory?  what's that?
  //  aligns[*index] = result;
  //  aligns[hllindex] = result;


}

void doReanchorHLLs(align *aligns[],
		 int *index, int hllindex) {
  int i;

  // for each pair of hlls from (i to first) and (i to second)

  for(i=0; i<*index; i++) {
    aligns[i]->hlls[*index] = 
      reanchorHLL(mergeHLLs(aligns[i]->hlls[*index], 0, 
			    aligns[i]->hlls[hllindex], 0));

    //    if (verbose) {
    //  printf("aligns[%d]->hlls[%d]\n",i ,*index);
    //  printHLL(aligns[i]->hlls[*index]);
    //   }
    aligns[i]->hlls[hllindex] = 0;
  }
  for(i=*index+1; i<hllindex; i++) {
    aligns[*index]->hlls[i] = 
      reanchorHLL(mergeHLLs(aligns[*index]->hlls[i], 0, 
			    aligns[i]->hlls[hllindex], 1));
    //  if (verbose) {
    //  printf("aligns[%d]->hlls[%d]\n",*index ,i);
    //  printHLL(aligns[*index]->hlls[i]);
    //  }
    aligns[i]->hlls[hllindex] = 0;
  }
  for(i=hllindex+1; i<numseqs; i++) {
    aligns[*index]->hlls[i] =  
      reanchorHLL(mergeHLLs(aligns[*index]->hlls[i], 0, 
			    aligns[hllindex]->hlls[i], 0));
    // if (verbose) {
    //  printf("aligns[%d]->hlls[%d]\n", *index, i);
    //  printHLL(aligns[*index]->hlls[i]);
    // }
    aligns[hllindex]->hlls[i] = 0;
  }
}


align* processAlign(align *aligns[], align *a1, align *a2, int *index) {
  int hllindex;
  align *first, *second, *result, *uni;

  orderAligns(a1, a2, &first, &second, index, &hllindex);
  if (verbose)
    printHLL(aligns[first->index]->hlls[hllindex]);  
  result = makeAlign(first, second, aligns[first->index]->hlls[hllindex], &uni);
  result->index = *index;

  doRemapHLLs(aligns, uni, index, hllindex);
  
  doReanchorHLLs(aligns, index, hllindex);

  // if the constituent alignments were not simple alignments, free them
  freeAlign(uni);
  if (first->numseq > 1) freeAlign(first);
  if (second->numseq > 1) freeAlign(second);

  return(result);
}


hll* regenAnchors (align* new, align *current, align *rpntree[], int length) {
  hll* stack[MAX_SEQ];
  hll* temp;
  int i = 0, sp = 0;
  int index=0;

  //  printf("Inside regenAnchs, length=%d\n", length);

  while (i < length) {
    if (rpntree[i]) {
      //      printf("PUSHAnchs %d\n", sp);
      if (rpntree[i] != new) {
	temp = createGetHLLFromAligns(rpntree[i], new);
	stack[sp++] = remapHLLs(temp, 0, current, getSeqNum(current, rpntree[i]->seqs[0]));
      }
      else
	stack[sp++] = 0;

    }
    else {
      /*
      printf("POPAnchs %d\n", sp);
      printf("stack[sp-1]\n");
      printHLL(stack[sp-1]);  
      printf("stack[sp-2]\n");
      printHLL(stack[sp-2]);  
      */
      stack[sp-2] = mergeHLLs(stack[sp-1], 0, stack[sp-2], 0);
      /*
      printf("preresult\n");
      printHLL(stack[sp-2]);  
      */
      stack[sp-2] = reanchorHLL(stack[sp-2]);
      /*
      printf("result\n");
      printHLL(stack[sp-2]);
      printf("finished\n");
      */
      stack[--sp] = 0;      
    }
    i++;
  }
  return stack[sp-1];
}

align* iterativeImprovement (align *current, align *rpntree[], int length) {
  int converged = 0;
  int i=0, oldscore, cutoff;
  seq *removed;
  align *readd, *old, *new;
  hll* anchs, *tt;
  if (current->numseq <= 2)
    return current;
  //  printf("iterative improvement!\n");

  cutoff = cutoffmatch *  match;
  fprintf(stderr, "cutoff = %d\n", cutoff);
  while (!converged) {

    // Throw out a sequence.  Calling code in multial.
    removed = current->seqs[0];
    new = findAlignByName(simaligns, removed->name);
    old = current;
    anchs = getAnchsFromAlign(current, 0, cutoff);
    current = removeSeq(current, 0);
    free (old);

    // Re-map Anchors...
    //    anchs = regenAnchors(new, current, rpntree, length);

    // Re-align this thrown-out sequence to the remaining alignment.
    //printHLL(anchs);  
    current = makeAlign (current, new, anchs, &old);
    if (verbose) {
      printf("improved:\n");
      printHLL(anchs);  
      printTextAlign(stdout, current);  
    }
    while (anchs) {
      tt = anchs;
      anchs = anchs->next;
      free (tt);
    }
    free (old);

    i++;
    if (i==numseqs*itertimes) converged = 1;
  }
  return current;
}



int treeToRPN(char *treestr, align *stack[MAX_SEQ*2], int *depth) {

  int i=0; int j, k; 
  char buffer[256];

  while (treestr[i]!='(') { i++; } i++;

  while ((treestr[i] != ')') && (treestr[i] != '\0')) { 
    //    printf("%d: %s\n", *depth, treestr+i);

  
    if (treestr[i]=='(') {
      i += treeToRPN(treestr+i, stack, depth);
    }  
    else if (isalpha(treestr[i])) {
      k = 0;
      // push alignment
      while((!isspace(treestr[i])) && (treestr[i]!='(') && (treestr[i]!=')')) { 
	buffer[k++] = treestr[i++];
      }
      buffer[k] = 0;
      stack[(*depth)++]=findAlignByName(simaligns, buffer);
      //      printf("pushed: %s\n", stack[*depth-1]->seqs[0]->name);
    }
    else if (treestr[i]==')')
      // (*depth)++;
      break;
    else { i++; }

  }

  if (treestr[i]==')') {
    (*depth)++; //null is '+'
    return i+1;
  }
 if (treestr[i] == '\0') { 
   fprintf(stderr, "ERROR parsing tree, depth %d, %d chars read", *depth, i);
   exit(1);
 }
}

align* procStack(align* rpntree[MAX_SEQ*2], int length, align *myaligns[]) {
  align* stack[MAX_SEQ];
  int i = 0, sp = 0;
  int index=0;

  //  printf("Inside procStack, length=%d\n", length);

  while (i < length) {
    if (rpntree[i]) {
      //  printf("PUSH %d\n", sp);
      stack[sp++] = rpntree[i];
    }
    else {
      // printf("POP %d\n", sp);
      stack[sp-2] = processAlign(myaligns, stack[sp-2], stack[sp-1], &index);
      stack[--sp] = 0;      
      if(verbose) printTextAlign(stdout, stack[sp-1]);  
    }
    if (nested) {
      iterativeImprovement(stack[sp-1], rpntree, i);
    }
    i++;
  }
  return stack[sp-1];
}


void graphCollapsal (align *simaligns[]) {
  
  // for now...
  
  fprintf(stderr, "Please specify a phylogenetic tree, using [-tree]\n");
  exit(1);
}

int parseParameters(int argc, char** argv,
		    FileBuffer seqfile, seq **seqs, char **treestr) {

  int i=1;

  if (argc < 3) {
    if (argc == 2)
      if (!strcmp(argv[1], "-version") || !strcmp(argv[1], "-Version")) {
        fprintf(stderr, "MLAGAN version %s\n", VER_NUM);
        exit(0);
      }
    usage();
    return 1;
  }

  while((argv[i][0]!='-')) {

    // Read in sequence files.
   
    //    printf("sequence %d: %s\n", i, argv[i]);

    if (!(seqfile = FileOpen(argv[i]))) {
      fprintf(stderr, "couldnt open dbase file %s\n",argv[i]);
      usage();
      return 2;
    }

    seqs[numseqs] = FileRead(seqfile, 0, 0, VER_MLAGAN);
    seqs[numseqs]->filename = argv[i];    

    numseqs++;

    if(++i>=argc) break;
  }

  //  printf("\n");

  while (i<argc) {
   
    // printf("parameters: %s\n", argv[i]);

    if (!(strcmp(argv[i], "-nested") || 
	  strcmp(argv[i], "-nopost") || 
	  strcmp(argv[i], "-postir") || 
	  strcmp(argv[i], "-lazy") || 
	  strcmp(argv[i], "-verbose") || 
	  strcmp(argv[i], "-out") ||
	  strcmp(argv[i], "-match") || strcmp(argv[i], "-mismatch") ||
	  strcmp(argv[i], "-gapstart") || strcmp(argv[i], "-gapend") ||
	  strcmp(argv[i], "-gapcont") || strcmp(argv[i], "-gapperseq") ||
	  strcmp(argv[i], "-overlap") || strcmp(argv[i], "-glwidth") ||
	  strcmp(argv[i], "-tree"))) {
      fprintf(stderr, "unrecognized parameter: %s\n", argv[i]);
      usage();
      return 1;
    }
    if (!strcmp(argv[i], "-nested")) { 
      nested = 1; 
    }

    if (!strcmp(argv[i], "-verbose")) { 
      verbose = 1; 
    }

    if (!strcmp(argv[i], "-postir")) { 
      postir = 1; 
    }
    if (!strcmp(argv[i], "-lazy")) { 
      lazy = 1; 
    }

    if (!strcmp(argv[i], "-out")) {
      i++;
      if ((i>=argc) || (argv[i][0]=='-')) {
	fprintf(stderr, "missing parameter specification for [-out].\n");
	return 1;
      }
      fprintf(stderr, "outputting to: %s\n", argv[i]);
      outfile = fopen(argv[i], "w");
      if (outfile==NULL) {
	fprintf(stderr, "error with output file...\n");
	exit(2);
      }
    }

    if (!strcmp(argv[i], "-tree")) {
      i++;
      if ((i>=argc) || (argv[i][0]=='-')) {
	fprintf(stderr, "missing parameter specification for [-tree].\n");
	return 1;
      }
      notree = 0;
      *treestr = argv[i];
      fprintf(stderr, "using given phylogenetic tree:\n%s\n", *treestr); 
    }

    if (!strcmp(argv[i], "-match")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-match].\n");
	return 1;
      }
      match = atoi(argv[i]);
      fprintf(stderr, "using match score: %d\n", match); 
    }
    if (!strcmp(argv[i], "-mismatch")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-mismatch].\n");
	return 1;
      }
      mismatch = atoi(argv[i]);
      fprintf(stderr, "using mismatch score: %d\n", mismatch); 
    }
    if (!strcmp(argv[i], "-gapstart")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-gapstart].\n");
	return 1;
      }
      gapstart = atoi(argv[i]);
      fprintf(stderr, "using gapstart score: %d\n", gapstart); 
    }
    if (!strcmp(argv[i], "-gapend")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-gapend].\n");
	return 1;
      }
      gapend = atoi(argv[i]);
      fprintf(stderr, "using gapend score: %d\n", gapend); 
    }
    if (!strcmp(argv[i], "-gapcont")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-gapcont].\n");
	return 1;
      }
      gapcont = atoi(argv[i]);
      fprintf(stderr, "using gapcont score: %d\n", gapcont); 
    }
    if (!strcmp(argv[i], "-gapperseq")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-gapperseq].\n");
	return 1;
      }
      gapperseq = atoi(argv[i]);
      fprintf(stderr, "using gapperseq score: %d\n", gapperseq); 
    }
    if (!strcmp(argv[i], "-overlap")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-overlap].\n");
	return 1;
      }
      overlap = atoi(argv[i]);
      fprintf(stderr, "using overlap value: %d\n", overlap); 
    }
    if (!strcmp(argv[i], "-glwidth")) {
      i++;
      if (i>=argc) {
	fprintf(stderr, "missing parameter specification for [-glwidth].\n");
	return 1;
      }
      glwidth = atoi(argv[i]);
      fprintf(stderr, "using glwidth value: %d\n", glwidth); 
    }

    i++;
  }

  setScores(match, mismatch,
	    gapstart, gapend,
	    gapcont, gapperseq,
	    overlap, glwidth);

  return 0;
}



int main(int argc, char** argv) {
  FileBuffer seqfile;
  seq **seqs;

  int i = 1, j = 1;
  char command[256];

  char *treestr = NULL;
  align *stack[MAX_SEQ*2];
  align *final;
  align *myaligns[MAX_SEQ];

  outfile = stdout;
  lagan_dir = getenv ("LAGAN_DIR");
  if (!lagan_dir) {
    fprintf(stderr, "Environment variable LAGAN_DIR not set\n");
    exit(1);
  }

  initLib();

  seqs = (seq**) malloc((argc-1)*sizeof(seq*));

  if (parseParameters(argc, argv, seqfile, seqs, &treestr)) return 1;

  gapstart += gapcont;

  // Take all sequences and make simple alignments

  for (i=0; i<numseqs; i++) {
    myaligns[i]=simaligns[i]=mkSimAlign(seqs[i]);
    simaligns[i]->index = i;
  }

  // Find all pairwise anchors.

  for (i=0; i<(numseqs-1); i++) {
    for (j=i+1; j<numseqs; j++) {
      simaligns[i]->hlls[j]=createGetHLLFromAligns(simaligns[i], simaligns[j]);
      /*      
      printf("Create Check: simaligns[%d]->hlls[%d].score=%g\n",
	     i,j,
	     simaligns[i]->hlls[j]==NULL ? 0 : simaligns[i]->hlls[j]->score);
      */
    }
  }

  //  printf("\n");

  for (i=0; i<MAX_SEQ*2; i++) {
    stack[i] = NULL;
  }

  /*
  for (i=0; i<(numseqs-1); i++) {
    for (j=i+1; j<numseqs; j++) {
      printf("Sanity Check: simaligns[%d]->hlls[%d].score=%g\n",
	     i,j,
	     simaligns[i]->hlls[j]==NULL ? 0 : simaligns[i]->hlls[j]->score);
    }
  }
  */

  // Processall closest pairs 

  if (notree) { 
    graphCollapsal(myaligns);
  }
  else {

    fprintf(stderr, "\n****************************\n");
    fprintf(stderr, "gs: %d; ge: %d;\n", gapstart, gapend);
    fprintf(stderr, "gc: %d; gp: %d\n", gapcont, gapperseq);
    fprintf(stderr, "match: %d; mismatch: %d\n", match, mismatch);
    fprintf(stderr, "overlap: %d; glwidth: %d\n", overlap, glwidth);
    fprintf(stderr, "\n****************************\n");

    i = 0;
    treeToRPN(treestr, stack, &i);
    final = procStack(stack, i, myaligns);
  }

  if (postir) {
    final = iterativeImprovement(final, stack, i);
  }

  // Ouput end result.
  fprintf(stderr, "final alignment... \n");

  printFASTAAlign(outfile, final);
  if (outfile != stdout) fclose (outfile);

  // free memory ?

  fprintf(stderr, "mlagan -- end.\n");
  return 0;
}














