# The master program gets the configurations in descending order of priority
# and then it gives them to clients that request them.
# If a configuration has failed for one slave, no other slave 
# gets that configuration.
# If a configuration succeeds for one or more slaves, the master
# keeps track of that information in configstats.

# configstat maps configurations to a vector that is as long as 
# the number of slaves.
# For a particular configuration c, configstat[c] is set to all 0s.
# If slave i succeeds with configuration c, then the ith
# entry of configstat[c] is set to +1.
# If slave i fails with configuration c, then the ith
# entry of configstat[c] is set to -1.
# Configuration c succeeds if the min value is 1. It fails if the min value
# is -1. 
import zmq, time
import copy

context = zmq.Context()
socket = context.socket(zmq.REP)
socket.bind("tcp://*:50008")

numslaves = 2  # if this number of slaves approve, then we have found a config
i = 0
a = [0] * numslaves
print "a is: ", a


# master has a list of all connections
fileicareabout = open("versionclimber_configs","r")
configs = fileicareabout.readlines()
fileicareabout.close()
configstat = {}
for c in configs:
  configstat[c[:-1]] = copy.deepcopy(a)

# configurations start out with all 0s and then the 0 for slave i
# either a -1 (if fail for slave i) or 1 (if succeed for slave i.

# find work for this slave from configindex+1 (the first config after
# the last one tried by this slave) to the end.
# pass by all configs that have a -1 (indicating failure).
# If they all have failed then there is nothing good
def requestwork(slaveid, configindex):
   i = configindex
   c = configs[i][:-1]
   if (configstat[c][slaveid] == 1): # this was good for us
     if min(configstat[c]) == 1:
       print "Success with: ", configs[i]
     if min(configstat[c]) == 0:
       print "Slave ", slaveid, " has had success with configuration ", c, " and will wait "
       return(str(i) + ' ' + c + ' Already_done')
   i = configindex + 1
   c = (configs[i])[:-1]
   while(i < len(configs)):
     c = (configs[i])[:-1]
     if 0 == min(configstat[c]): # still unknown
       return(str(i) + ' ' + c + ' Not_yet')
     if 1 == min(configstat[c]): # still unknown
       return(str(i) + ' ' + c + ' Success')
     i+= 1
   return(str(i) + ' ' +  c + ' Tried_everything')

# if the slave succeeded at this config, then set the appropriate element
# of configstat vector to status (and check whether that is a good config). 
# 1 will be a success status and -1 a failure status.
def updatestatus(slaveid, configindex, status):
  global configstat
  c = (configs[configindex])[:-1]
  configstat[c][slaveid] = status
  if 1 == min(configstat[c]):
    print "configuration: ", c , " works."
    return ("Success")
  return ("Keep_going")
   
  
while True:
    data = socket.recv()
    print 'data are ', data
    if not data: break
    fields = data.split(" ") 
    print "fields are: ", fields
    # format is slave number, opcode, args
    # opcodes can be 'requestwork' with argument last configindex tried
    #    -- response can be a new config or 'done'
    # 'updatestatus' with argument configindex and succeed(1) or fail(0) 
    numpart= ((fields[0]).split(":"))[1]
    if fields[1] == 'requestwork':
       ret = requestwork(int(numpart), int(fields[2]))
       print 'ret from requestwork: ', ret
    if fields[1] == 'updatestatus':
       ret = updatestatus(int(numpart), int(fields[2]), int(fields[3]))
       print 'ret from updatestatus: ', ret
    if ret == 'Success':
       break
    print "return value: ", ret
    print "~~~~~~~~"
    socket.send("%s " % (ret))
