import pygame
import os

class ImageLoader:
	def __init__(self, application, img_dir='img'):
		self.img_dir = img_dir

		self.images = {}
	# __init__

	def load(self, image_name):
		self.images[image_name] = pygame.image.load(os.path.join(self.img_dir, image_name))
	# load

	def get(self, image_name):
		try:
			return self.images[image_name]
		except KeyError:
			self.load(image_name)
			return self.images[image_name]
		# try
	# get
# ImageLoader