import pygame
from item import Item

class Grid:
	border = 10
	lines_color = (200, 200, 200)
	numbers_color = (255, 255, 255)

	def __init__(self, application, text_stream_id1, text_stream_id2, rect=None, color=(255, 255, 255)):
		self.application = application
		self.color = color

		self.label_stream_id1 = pygame.transform.rotate(
			self.application.font_slider.render(text_stream_id1, 1, Grid.numbers_color), 90
		)
		self.label_stream_id2 = self.application.font_slider.render(text_stream_id2, 1, Grid.numbers_color)

		if rect:
			self.rect = rect
		else:
			min_size = min(application.size)*3/4
			side = min_size-Grid.border
			self.rect = pygame.Rect(application.size[0]/2-side/2, Grid.border, side, side)
		# if

		self.surface = pygame.Surface((self.rect.width, self.rect.height))
	# __init__

	def generate(self):
		pygame.draw.rect(self.surface, self.color, (0, 0, self.rect.width, self.rect.height))
	# generate

	def draw(self, surface):
		surface.blit(
			self.label_stream_id1, 
			(int(self.rect.x - self.label_stream_id1.get_width()/2 - 40), int(self.rect.y + self.rect.height/2 - self.label_stream_id1.get_height()/2))
		)
		surface.blit(
			self.label_stream_id2, 
			(int(self.rect.x + self.rect.width/2 - self.label_stream_id2.get_width()/2), int(self.rect.y+self.rect.height+25))
		)

		try:
			ids1 = self.application.item_manager.stream_ids1()
			for stream_id1 in xrange(min(ids1), max(ids1)+1):
				y = self.application.item_manager.get_pos([stream_id1, 0])[1]
				pygame.draw.line(self.surface, Grid.lines_color, (Item.radius, y), (self.rect.width-Item.radius, y))

				label = self.application.font_grid.render(str(stream_id1), 1, Grid.numbers_color)
				surface.blit(label, (self.rect.x-20, self.rect.y+y-8))
			# for

			ids2 = self.application.item_manager.stream_ids2()
			for stream_id2 in xrange(min(ids2), max(ids2)+1):
				x = self.application.item_manager.get_pos([0, stream_id2])[0]
				pygame.draw.line(self.surface, Grid.lines_color, (x, Item.radius), (x, self.rect.height-Item.radius))

				label = self.application.font_grid.render(str(stream_id2), 1, Grid.numbers_color)
				surface.blit(label, (self.rect.x+x-4*len(str(stream_id2)), self.rect.y+self.rect.height))
			# for
		except: pass
	# draw
# Grid