#!/usr/bin/env python
# -*- coding: utf-8 -*-

#-----------------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------------

import sys
import pygame
from pygame.locals import *
import os

from application import Application
from item_manager import ItemManager
from grid import Grid
from slider import Slider
from image_loader import ImageLoader
from item import Item
from button import Button
from button_manager import ButtonManager
from config import Config

#-----------------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------------

try:
	csv_file_path = sys.argv[1]
except IndexError:
	print 'Usage: ./csv-gui <csv_file>'
	print 'Example: ./csv-gui myOutput.csv'

	sys.exit(0)
# try

#-----------------------------------------------------------------------------------------------------

pygame.init()
pygame.font.init()

application = Application('image.png', size=(1024, 768))

config = Config(file='config.ini')

screen = pygame.display.set_mode(application.size)
pygame.display.set_caption(config.section_map('Config')['title'])
pygame.display.set_icon(pygame.image.load(os.path.join('img', 'icon.png')))

#-----------------------------------------------------------------------------------------------------

application.draw_loading(screen)
application.image_loader = ImageLoader(application)
Item.load_image(application)

grid = Grid(application, config.section_map('Config')['stream_id1'], config.section_map('Config')['stream_id2'])
application.grid = grid
application.gen_cover_image_pos()

application.label_coefficient = application.font_slider.render(config.section_map('Config')['coefficient'], 1, (255, 255, 255))
application.label_coefficient_pos = (
	int(application.size[0]/2 + grid.rect.width/2 + (application.size[0]-grid.rect.width)/4 - application.label_coefficient.get_width()/2), 
	int(grid.rect.y + grid.rect.height/2 - 100)
)

slider = Slider(application, config.section_map('Config')['time'])
application.slider = slider

item_manager = ItemManager(application)
application.item_manager = item_manager
item_manager.load(csv_file_path)

button_manager = ButtonManager(application)
application.button_manager = button_manager

left_button = Button(application, slider)
right_button = Button(application, slider, index=1)

button_manager.add(left_button)
button_manager.add(right_button)

button_manager.left_button = left_button
button_manager.right_button = right_button

#-----------------------------------------------------------------------------------------------------

running = True
while running:
	for event in pygame.event.get():
		if event.type == QUIT or event.type == KEYDOWN and event.key == K_ESCAPE:
			running = False
		elif event.type == MOUSEBUTTONDOWN and event.button == 1:
			button_manager.mouse_down()
		elif event.type == MOUSEBUTTONUP and event.button == 1:
			button_manager.mouse_up()
		elif event.type == KEYDOWN and event.key == K_LEFT:
			button_manager.key_left()
		elif event.type == KEYDOWN and event.key == K_RIGHT:
			button_manager.key_right()
		# if
	# for

	screen.fill((0, 0, 0))

	item_manager.update()
	button_manager.update()

	grid.generate()
	grid.draw(screen)
	item_manager.draw(grid.surface, screen)
	slider.draw(screen)
	button_manager.draw(screen)

	application.draw_cover_image(screen)

	screen.blit(grid.surface, grid.rect)

	if application.to_blit_surface:
		screen.blit(application.to_blit_surface, application.to_blit_pos)
	# if

	pygame.display.flip()
# while

#-----------------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------------