#include "Reconstruction.h"
#include "Offline.h"
#include "grb.h"
#include "cfortran.h"
#include "hbook.h"
#include <time.h>


float pawc_[PAWC_SIZE];
clock_t     clock(void);

int main( int argc,char *argv[] )
{ 
  EVENT_DATA      eventData;
  GRID_COORD      coords;
  PMT_INFO        pmtInfo;
  ANGLE_CONTROL   angleCon;
  CORE_CONTROL    coreCon;
  GH_CONTROL      ghCon;
  DATA_CONTROL    dataCon;
  CAL_CONTROL     calCon;

  char   filename[300],outfilename[300],logfilename[300],str[300];
  int    Data,nFit_event,Ftape;
  double nValid=0.,nEvents=0.;
  float  x2_event;
  time_t timenow,myt;
  int    hour, day, month, year,mode,lastday;
  char   atime[100],tcrap[100],ttime[100];

  HLIMIT(PAWC_SIZE);
  
  /* read in bad tubes from file "DontFits.txt" */
  GetBadPMTs(&pmtInfo);
  
  /* Initialize control structures */
  InitControl(&angleCon,&coreCon,&dataCon,&ghCon,&calCon);

  /* read in PMT positions from file */
  GetCoords(&coords,&dataCon);
 
  if (argc!=2) {
    printf("Usage: grb <filename>\n");
    exit(0); 
  }
 
  sprintf(filename,"%s",argv[1]);
  strcpy(dataCon.inFile,filename);
  grb_finder_fileopen(outfilename,logfilename,1,999); //called when code first run
  
  //get current date and time
  
  myt = time(NULL);
  strftime(atime,100,"%Y-%m-%d %H:%M:%S UT", gmtime(&myt));
  sscanf(atime,"%04d-%02d-%02d %02d%s",&year, &month, &day, &hour, tcrap);
  
  lastday=day;
  
  
  do {
    
    Data = MilagroEvent4(&eventData, &dataCon, &coords,&calCon);

    nEvents+=1.;
    
    if (nEvents-(float)((int)nEvents/1000000)*1000000<1.) {
      sprintf(str,"%12.0f events\n",nEvents);
      grb_finder_logger(str);
      //get current date and time
      //check time every 1000000 events and update file if day changed
      myt = time(NULL);
      strftime(atime,100,"%Y-%m-%d %H:%M:%S UT", gmtime(&myt));
      sscanf(atime,"%04d-%02d-%02d %02d%s",&year, &month, &day, &hour, tcrap);
      if(lastday!=day){
	grb_finder_fileopen(outfilename,logfilename,2,
			    eventData.recEvent.reconInfo.clockData.julDate);
	lastday=day;
      }
    }    
    nFit_event  = eventData.recEvent.reconInfo.angleFit.nFit;
    x2_event    = ((float)eventData.recEvent.reconInfo.poolFit.nPMT2[1])/
                    eventData.recEvent.reconInfo.ghRecon.maxPEmuon;

    if (nFit_event>NFIT_CUT && x2_event>X2_CUT ) {
      nValid += 1.;
      grb_finder(Data,&eventData,outfilename);
    }

  } while(Data); /* end loop over events */

  sprintf(str,"nEvents = %13.0f\n",nEvents);
  grb_finder_logger(str);
  sprintf(str,"nValid  = %13.0f\n",nValid);
  grb_finder_logger(str);
} /* end main */


