#include <math.h>

double pois(double Nexp, double Nobs);

int main(int argc, char *argv[]) {
  
  
  double i,prob,totprob;
  double Nexp,Nobs;
  
  if (argc!=3) {
    printf("usage: pois <Nexp> <Nobs>\n");
    exit(0);
  }

  Nexp = atof(*++argv);
  Nobs = atof(*++argv);

 
  totprob =0.;
  i=Nobs;
 
  do {
    prob     = pois(Nexp,i);
    totprob += prob;
    i+=1.;
  } while (prob/totprob>1.e-8);
  
  return totprob;
}

double pois(double Nexp, double Nobs) {
  
  static double pi=3.1415926265;
  static double xfac,power,prob,fact;

  /*  Calculate probability */

  xfac = 1.;
  if (Nobs<=1.) {
    power = Nexp;
    if(Nobs==0.) power=1.;
    prob = exp(-Nexp)*power/xfac;
  } else {
    fact = 0.5*log(2.*pi) + (Nobs + 0.5)*log(Nobs) - Nobs +
      1./(12.*Nobs) - 1./(360.*pow(Nobs,3.)) + 1./(1260.*pow(Nobs,5));
    prob = -Nexp + Nobs*log(Nexp) - fact;
    prob = exp(prob);
  }

  return prob;

}

