//give start date and stop date. code will return root file with 
//summed histograms for that time period.

#include <sys/types.h>
#include <time.h>
#include <string>
#include <getopt.h>
#include <zlib.h>
#include <iostream.h>
#include <fstream.h>
#include <unistd.h>
#include "TROOT.h"
#include "TFile.h"
#include "TH1.h" 
#include "TCanvas.h"
#include "TH2.h"
#include "TStyle.h"
#include "TFrame.h"
#include "TApplication.h"
#include "TApplicationImp.h"
#include "TNtuple.h"
#include "TPostScript.h"
#include "TText.h"
#include "TLine.h"
#include "TGraph.h"
#include "TAxis.h"

void main(int argc,char *argv[]){

  int     i,j,k;
  int     smonth,sday,syear;
  int     emonth,eday,eyear;
  char    hsname[300],hbname[300],hpname[300];
  char    rname[300];
  
  TH1F    *hs[360],*hb[360],*hp[360];
  TH1F    *hst[360],*hbt[360],*hpt[360];

  
  sscanf(argv[1],"%d",&smonth);
  sscanf(argv[2],"%d",&sday);
  sscanf(argv[3],"%d",&syear);
  sscanf(argv[4],"%d",&emonth);
  sscanf(argv[5],"%d",&eday);
  sscanf(argv[6],"%d",&eyear);

  TFile *nrf = new TFile("summed.root","RECREATE");

  /*
  if(smonth==emonth){//same month
  }
  else{//need to find last day of start month
  */

  for(i=sday;i<=eday;i++){
    
    sprintf(rname,"grb_short_%0.2d-%0.2d-%4d.root",smonth,i,syear);   
    TFile day(rname);
    for(j=0;j<=13;j++){
      sprintf(hsname,"h%d",j*10+1);
      sprintf(hbname,"h%d",j*10+2);
      sprintf(hpname,"h%d",j*10+3);
      cout<<"1";
      if(i==sday){//create histos
	hs[j]=(TH1F*)day.Get(hsname);
	hb[j]=(TH1F*)day.Get(hbname);
	hp[j]=(TH1F*)day.Get(hpname);

	cout<<"2";
      }
      else{ //add histos
      	cout<<endl;
	cout<<i<<" "<<j<<endl;
	cout<<hsname<<endl;
	cout<<"3";
	hst[j]=(TH1F*)day.Get(hsname);
	cout<<"4";
	hs[j]->Add(hst[j],1.);
	cout<<"5";
	hbt[j]=(TH1F*)day.Get(hbname);
	hb[j]->Add(hbt[j],1.);
	hpt[j]=(TH1F*)day.Get(hpname);
	hp[j]->Add(hpt[j],1.);
      }
      
    }
      
    day.Close();
  }

    nrf->Write();
    nrf->Close();
    cout<<"6";
}
