#include "Reconstruction.h"
#include "Offline.h"
#include "grb.h"

double index2ha( int index ) {
  double ha;
  ha = (double) (index-NHA_BINS/2);
  ha *= BINSIZE;
  return ha;
}

double index2dec (int index ) { /* declination goes from -60 to +90 */
  double dec;
  dec = (double) index;
  dec *= BINSIZE;
  dec -= 60.;
  return dec;
}

int ha2index( double ha ) {
  int index;
  ha +=180.;
  ha /=BINSIZE;
  index = (int) (ha+.5);
  if (index>=NHA_BINS) index = NHA_BINS-1;
  if (index<0) index=0;
  return index;
}

int dec2index (double dec ) {
  int index;
  dec += 60.;
  dec /=BINSIZE;
  index = (int) (dec+.5);
  if (index<0) index=0;
  if (index>=NDEC_BINS) index = NDEC_BINS-1;
  return index;
}
  
  

