#include "Reconstruction.h"
#include "Offline.h"
#include "cfortran.h"
#include "hbook.h"
#include "grb.h"

#define SEARCH_THRESH 2

double pois( double, double);
double intpois( double, double);


int grb_finder_evaldata_table(EVENT *evbuffer,MAP *maps,PROB *prob,
                              double duration, int dindex, int nTail, 
                              int nTailBack, int nBuff, unsigned int julDate,
			      int runum, int subrunum) 
{
  double t0,t1,tstart,tend,t0_10s,t1_10s;
  int nallsky_10s,ihits;
  int dha,xha,ddec,xdec,nallsky,nEval,icount,iback,nhits;
  int iha,idec,i,j,signal,iend;
  float temp,xallsky,total;
  int   ixallsky,nhabins,maxdec,ipublish;
  unsigned short int *sigptr;
  unsigned int       *backptr;
  static HIT hitlist[1000000];
  static int iev0[NDUR],iev1[NDUR],iev0_10s[NDUR],iev1_10s[NDUR];
  char       str[300];
  GRB_CANDIDATE cand;
  
  /* tstart and tend are the start and end times for the interval to search */
  /* t0 and t1 are the starting and ending times for the search interval   */
  /* t1 and t0 are taken with respect to the start of the day, not the first event */

  tstart      = evbuffer[nTail].time-duration; 
  if (tstart<evbuffer[nTailBack].time) tstart=evbuffer[nTailBack].time;
  iend        = nTail+nBuff-1;
  if (iend>EVBUFFSIZE) iend-=EVBUFFSIZE;
  tend        = evbuffer[iend].time;
  t0          = (floor(1.0+tstart/(duration*T_STEP)))*(duration*T_STEP); 
  if (nTail==nTailBack) {   /* background was reset, don't look back in time */ 
    iev1[dindex] = nTailBack;
    iev0[dindex] = nTailBack;
    iev1_10s[dindex] = nTailBack;
    iev0_10s[dindex] = nTailBack;
  } else {                  /* otherwise, start up where I left off          */
    iev1[dindex]     = iev0[dindex];
    iev1_10s[dindex] = iev0_10s[dindex];
  }
  nallsky     = 0;
  nallsky_10s = 0;
  nEval       = 0;
  t0_10s      = tstart;
  nhits       = 0;
  signal      = 0;
  ipublish    = 1;   /* publish not yet called */

  sprintf(str," %f %f ",tstart,tend);
  grb_finder_logger(str);
  /* zero out signal map */
  sigptr = &(maps->sigmap[0][0]);
  for (i=0;i<NHA_BINS*NDEC_BINS;i++) {
    *sigptr = 0;
    sigptr++;
  }
  
  do {
    /* add events to signal map */
    t1 = t0+duration;
    while (evbuffer[iev1[dindex]].time<t1) {
      iha = evbuffer[iev1[dindex]].iha;
      idec= evbuffer[iev1[dindex]].idec;
      nhabins = prob->habins[idec];
      if (iha+nhabins>=prob->hamin && iha-nhabins<=prob->hamax &&
          idec+SEARCHBIN>=prob->decmin[iha] && idec-SEARCHBIN<=prob->decmax[iha]) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            maps->sigmap[iha+dha][idec+ddec]++;
            /* add to hit list */
            if (maps->sigmap[iha+dha][idec+ddec]==SEARCH_THRESH) {
              hitlist[nhits].iha  = iha+dha;
              hitlist[nhits].idec = idec+ddec;
              maps->hittable[iha+dha][idec+ddec]=nhits;
              nhits++;
            }
          }
        }
      }
      iev1[dindex]++;
      if (iev1[dindex]==EVBUFFSIZE) iev1[dindex]=0;
      nallsky++;
    }
    /* remove events from signal map */
    while (evbuffer[iev0[dindex]].time<t0) {
      iha = evbuffer[iev0[dindex]].iha;
      idec= evbuffer[iev0[dindex]].idec;
      nhabins = prob->habins[idec];
      if (iha+nhabins>=prob->hamin && iha-nhabins<=prob->hamax &&
          idec+SEARCHBIN>=prob->decmin[iha] && idec-SEARCHBIN<=prob->decmax[iha]) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            /* delete from hit list */
            /* when removing the data, I move the last table element to */
            /* the new opening. This could go faster if I used pointers */
            if (maps->sigmap[iha+dha][idec+ddec]==SEARCH_THRESH) {
              ihits = maps->hittable[iha+dha][idec+ddec];
              hitlist[ihits].iha  = hitlist[nhits-1].iha;
              hitlist[ihits].idec = hitlist[nhits-1].idec;
              maps->hittable[hitlist[ihits].iha][hitlist[ihits].idec]=ihits;
              nhits--;
            }
            maps->sigmap[iha+dha][idec+ddec]--;
          }
        }
      }
      iev0[dindex]++;
      if (iev0[dindex]==EVBUFFSIZE) iev0[dindex]=0;
      nallsky--;
    }

    /* count events in 10s time window arround search time */
    t0_10s = t0+duration/2.-5.;
    t1_10s = t0_10s+10.;
    if (t0_10s<tstart) {t0_10s=tstart;   t1_10s=tstart+10.;}
    if (t1_10s>tend)   {t0_10s=tend-10.; t1_10s=tend; }
    while (evbuffer[iev1_10s[dindex]].time<t1_10s) { 
      iev1_10s[dindex]++;      
      if (iev1_10s[dindex]==EVBUFFSIZE) iev1_10s[dindex]=0;
      nallsky_10s++; 
    }
    while (evbuffer[iev0_10s[dindex]].time<t0_10s) { 
      iev0_10s[dindex]++; 
      if (iev0_10s[dindex]==EVBUFFSIZE) iev0_10s[dindex]=0;
      nallsky_10s--; 
    }
    if (nallsky_10s==0 && nhits>0) {
      sprintf(str,"ERROR: Background=0: %d %d %f %f %f %f\n", iev1_10s[dindex],
              iev0_10s[dindex],t1_10s,t0_10s,tstart,tend);
      grb_finder_logger(str);
    }
    nEval++;
    /* Now I have the signal and background map */
    /* and the list of hits, search the map */
    xallsky = log((((float) nallsky_10s)*duration/10.))*PROB_BINSF/prob->span;
    ixallsky = (int) (xallsky+.5);
    for (i=0;i<nhits;i++) { 
      iha  = hitlist[i].iha;
      idec = hitlist[i].idec;
      signal = maps->sigmap[iha][idec];
      iback  = maps->backmap_index[iha][idec]+ixallsky;
      if (iback>=0 && iback<PROB_BINS && signal>=0 && signal<MAX_SIG) {
        prob->count[dindex][signal][iback]++;
      } else {
        sprintf(str,"Overflow: %d %d %d %d %d %f\n",signal,iback,maps->backmap_index[iha][idec],
                ixallsky,nallsky_10s,xallsky);
	grb_finder_logger(str);
      }
      if (prob->value[signal][iback]<prob->publish_threshold[dindex]) {
      /*
        grb_finder_publish(&ipublish,iha,idec,t0,duration,signal,
                exp(((float)iback)*prob->span/PROB_BINSF+prob->minback),
                prob->value[signal][iback],iback,ixallsky,julDate,
                evbuffer,nTail,nBuff,prob,dindex);
      */
        cand.iha         = iha;
        cand.idec        = idec;
        cand.t0          = t0;
        cand.duration    = duration;
	cand.runum       = runum;
	cand.subrunum    = subrunum;
	cand.signal      = signal;
        cand.back        = exp(((float)iback)*prob->span/PROB_BINSF+prob->minback);
        cand.grbprob     = prob->value[signal][iback];
        cand.nallsky_10s = nallsky_10s;
        cand.iback       = iback;
        cand.julDate     = julDate;
        cand.nTail       = nTail;
        cand.nBuff       = nBuff;
        cand.idur        = dindex;
        grb_finder_publish(&ipublish, &cand, evbuffer, prob);
      }
    }

    t0+=T_STEP*duration;
  } while (tend-t0>duration);

  /* if publish has been called then call again to log lowest prob hit */
  if (ipublish==0) { 
    ipublish = 2;
/*
    grb_finder_publish(&ipublish,iha,idec,t0,duration,signal,
                  exp(((float)iback)*prob->span/PROB_BINSF+prob->minback),
                  prob->value[signal][iback],iback,ixallsky,julDate,
                  evbuffer,nTail,nBuff,prob,dindex);
*/
    grb_finder_publish(&ipublish, &cand, evbuffer, prob);
  }

}
