//generate output filenames,etc
#include "Reconstruction.h"
#include "Offline.h"
#include "grb.h"
#include <time.h>

void grb_finder_fileopen(char *outfilename,char *logfilename,int call,unsigned int julDate){
  
  time_t timenow,myt;
  int    hour, day, month, year,lastday,lastmonth,lastyear,i,ultra,junk,junk2;
  char   atime[100],tcrap[100],ttime[100],command[300],rname[300],dir[300],cdir[300];
  FILE   *tcheck,*fptemp;

  //get current date and time
  
  
  myt = time(NULL);          
  strftime(atime,100,"%Y-%m-%d %H:%M:%S UT", gmtime(&myt));
  sscanf(atime,"%04d-%02d-%02d %02d%s",&year, &month, &day, &hour, tcrap);

  if(ON) {
    sprintf(dir,"/home/daq/grb/log/");
    sprintf(cdir,"/home/daq/grb/code/");
  }
  else{
    sprintf(dir,"./");
    sprintf(cdir,"./");
  }

  if(call==1){//first call just give files with today's date
    if(SHORTER){
      sprintf(outfilename,"%s/grb_ultrashort_%0.2d-%0.2d-%4d.his",dir,month,day,year);
      sprintf(logfilename,"%s/grb_ultrashort_log_%0.2d-%0.2d-%4d",dir,month,day,year);
    }
    else{ 
      sprintf(outfilename,"%s/grb_short_%0.2d-%0.2d-%4d.his",dir,month,day,year);
      sprintf(logfilename,"%s/grb_short_log_%0.2d-%0.2d-%4d",dir,month,day,year);
    }
    
    //check if file already exist when first opening
     
    if(fptemp=fopen(outfilename,"r")!=NULL){
      
  
      i=1;
      while(i){
	if(SHORTER){
	  sprintf(outfilename,
		  "%s/grb_ultrashort_%0.2d-%0.2d-%4d_%d.his",dir,month,day,year,i);
	  if(fptemp=fopen(outfilename,"r")==NULL){
	    break;
	    i=0;
	  }
	}
	else{ 
	  sprintf(outfilename,
		  "%s/grb_short_%0.2d-%0.2d-%4d_%d.his",dir,month,day,year,i);
	  if(fptemp=fopen(outfilename,"r")==NULL){
	    break;
	    i=0;
	  }
	}
      
	i++;
      
      }
    }
  }
  
  if(call==2){//day changed so make daily plots and give new filenames

    j2c(julDate-1,&lastmonth,&lastday,&lastyear,&junk2);

    if(SHORTER){
      sprintf(outfilename,"%s/grb_ultrashort_%0.2d-%0.2d-%4d.his",dir,month,day,year);
      sprintf(logfilename,"%s/grb_ultrashort_log_%0.2d-%0.2d-%4d",dir,month,day,year);      
      ultra=1;
      sprintf(rname,"%s/grb_ultrashort_%0.2d-%0.2d-%4d",dir,lastmonth,lastday,lastyear);
    }
    else{
      sprintf(outfilename,"%s/grb_short_%0.2d-%0.2d-%4d.his",dir,month,day,year);
      sprintf(logfilename,"%s/grb_short_log_%0.2d-%0.2d-%4d",dir,month,day,year);
      ultra=0;
      sprintf(rname,"%s/grb_short_%0.2d-%0.2d-%4d",dir,lastmonth,lastday,lastyear);
    }

    //also do daily plotting of stuff 
    
    sprintf(command,"$ROOTSYS/bin/h2root %s.his",rname);
    system(command);
    sprintf(command,"%s/grb_finder_plotter  %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d",
	    cdir,junk,junk,ultra,2,lastmonth,lastday,lastyear,NDUR,
	    junk,junk,junk,junk,junk,junk,junk,junk,junk,junk);
    system(command);
      
  }
  
  if(call==3){
    if(SHORTER){
      sprintf(logfilename,"%s/grb_ultrashort_log_%0.2d-%0.2d-%4d",dir,month,day,year);
    }
    else{ 
      sprintf(logfilename,"%s/grb_short_log_%0.2d-%0.2d-%4d",dir,month,day,year);
    }
  }
}




