#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include<malloc.h>
#include <assert.h>
//#include"function.h"
#define INFTY 99999999
#define TRUE 1
#define FALSE 0
#define mCOMP(a,b)  (a < b) ? a : b
#define MCOMP(a,b)  (a < b) ? (b-a-1) : (a-b-1)

int n;
int SpaceDim;
/* 
   Object in vector space model;
   index = real index;
   mark  = it is TRUE if during the search is alread visited
   *X    = Features vector;   
   *Dv   = Distance Vector from the antipole 
   Dc    = Distance from the Centroid Cluster;
*/

typedef struct OBJECT{
  int *index;
  float *X; 
  int *idx_CLU;
  float *Dv;
  float Dc;
  int   dvS;
  float Do;
}Object;

typedef struct OBJ {
  int key;
  int idx;
}Obj;

typedef struct PQ {
  Obj *dist;
  int heapsize;
}PriorityQueue;


/* Cluster of objects
   
   Centroid = Representant of the cluster
   Elements = Cluster members
   radius   = Cluster radius
   size     = Cluster size;
   struct Cluster Next = Pointer to the next cluster in the clustered space
                         Must be used during the search only over the clusters
*/


typedef struct C_POINTER{
  struct CLUSTER *N;
  struct C_POINTER *next;

}C_Pointer;

typedef struct CLUSTER{
  Object *Elements;
  Object *Centroid;
  float radius;
  int   size;
  int   idx_CLU;
  struct C_POINTER *neighbor;
  struct CLUSTER   *next;
  struct Worst_Tree *tree_node;
  int saturated;
  float *Dv;
}Cluster;


/* Worst Tree node:
  
   A B = Pointers to the furthest pair of the set;
   Dab = Distance between A and B;
   start = Starting point in the set of object   
   end   = End point of the set of object covered in the sub tree 
   SizeA = Size of the left child of the node
   SizeB = Size of the right child of the node
   Size  = Size of the tree rooted at this node
   Left Right = pointers to the left and right childrens
   clust = Pointer to the cluster of the node. Is is != NULL if the 
           node is a leaf;
   lead  = Boolend filed it is TRUE only if the node is a leaf
*/

typedef struct Worst_Tree{
  Object *A;
  Object *B;
  float Dab;
  float RadA;  
  float RadB;  
  
  //Object *C;   //   Riservati: Ancora non usati
  //Object *Cb;  //      "
  //float Dcc;   //      " 
  
  int start;   //  CAMPO DA ELIMINARE 
  int end;     //     "
  int SizeA;   //     "
  int SizeB;   //     "
  int Size;    //     "

  struct Worst_Tree *pred;
  struct Worst_Tree *left;
  struct Worst_Tree *right;
  Cluster *clust;           // leaf field
  Object *Centroid;         // leaf field Riservato: Ancora non usato;
  float *Rc;                // Riservato: ancora non usato
  unsigned int leaf;        // Riservato: ancora non usato
  unsigned int LEAFNUM;
}W_Tree;
