#include"functionA_S.h"
//#include <dmalloc.h>
#define LP 4

Cluster *C_List;
W_Tree *Tree;

int TOTAL;
Object *S;
float d;
char choice = 'I'; // inner product as default

int *MAPPA[10000];
int cont_words = 0;
char directed;

void visualizza(W_Tree *T,int *num_clusters) {
  if(!T)
    return;
  if(T->leaf==1) {
    //    fprintf(stderr,"\nfoglia! Size:%d %f\n",T->Size,T->Dab);
    (*num_clusters)++;
  }
  else {
    //fprintf(stderr,"A:%d SizeA:%d B:%d SizeB:%d Dab:%f\n",*T->A->index,T->SizeA,*T->B->index,T->SizeB,T->Dab);
    visualizza(T->left,num_clusters);
    visualizza(T->right,num_clusters);
  }
}

void write_output(W_Tree *T,char *name[],int *num_clusters,FILE *fp) {
  int i;
  if(!T)
    return;
  if(T->leaf==1) {
    if(T->Size > 2) {
      fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n     Centroid : '%s'\n",*num_clusters,T->Size,T->clust->radius,name[*T->clust->Centroid->index]);
      for(i=0;i<T->clust->size;i++) {
	fprintf(fp,"     Element  : '%s' [Dc:%f]\n",name[*T->clust->Elements[i].index],T->clust->Elements[i].Dc);
      }
      fprintf(fp,"\n");
    }
    else
      if(T->Size == 2) {
	fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n     Centroid : '%s'\n",*num_clusters,T->Size,T->Dab,name[*T->A->index]);
	fprintf(fp,"     Element  : '%s' [Dc:%f]\n",name[*T->B->index],T->Dab);
	fprintf(fp,"\n");
      }
      else {
	if(T->Size == 1) {
	  fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n     Centroid : '%s'\n",*num_clusters,T->Size,T->clust->radius,name[*T->A->index]);
	  fprintf(fp,"\n");
	}
      }
    //    fprintf(stderr,"\nfoglia! Size:%d %f\n",T->Size,T->Dab);
    (*num_clusters)++;
  }
  else {
    //fprintf(stderr,"A:%d SizeA:%d B:%d SizeB:%d Dab:%f\n",*T->A->index,T->SizeA,*T->B->index,T->SizeB,T->Dab);
    write_output(T->left,name,num_clusters,fp);
    write_output(T->right,name,num_clusters,fp);
  }
}

int main(int argc, char *argv[]) {
  int i,j=0,k,num,num_edge,e1,e2,num_grafo=0,range,*bool=NULL;
  char types[1000][50];
  char *name[10000],com[100],nnn[10],nnn1[10];
  int num_clusters,**Mat=NULL;
  FILE *fp,*fp1,*f1,*f2;
  char str[50];

  if(argc != 4 && argc != 5) {
    printf("GraphClustA_SUBDUE: Software for graphs clustering -- (C) 2003-2004\n");
    printf("USAGE:  <Dataset> <d/u> <1..4> [ <[I]nner Product / [E]uclidean [I/E]> ]\n");
    exit(-1);
  }
  if(argc == 5)
    sscanf(argv[4],"%c",&choice);
  
  if(choice!='I' && choice!='E') {
    fprintf(stderr,"\nUnrecognized value : %c. Please write 'I' or 'E'.\n",choice);
    exit(-1);
  }

  
  /* ----- PARSER STARTS ----- */

  
  fprintf(stderr,"\n\nParsing Dataset.....");
  sscanf(argv[2],"%c",&directed);
  if(directed!='d' && directed!='u') {
    fprintf(stderr,"\nUse 'd' or 'u' instead of %c\n\n",directed);
    exit(1);
  }
  fp = fopen(argv[1],"r");
  assert(fp);
  while(!feof(fp)) {
    fscanf(fp,"%s",str);
    if(feof(fp))
      break;
    if(str[0]=='#') { // New graph
      num = num_edge = 0;
      sprintf(nnn,"%d",num_grafo);
      fp1 = fopen(nnn,"w");
      assert(fp1);
      name[num_grafo] = (char *)malloc(sizeof(char)*(strlen(str)+1));
      strcpy(name[num_grafo],str);
      fscanf(fp,"%d",&num);
      for(i=0;i<num;i++) {
	fscanf(fp,"%s",types[i]);
	fprintf(fp1,"v %d %s\n",i+1,types[i]);
      }
      fscanf(fp,"%d",&num_edge);
      for(i=0;i<num_edge;i++) {
	fscanf(fp,"%d %d",&e1,&e2);
	fprintf(fp1,"%c %d %d A\n",directed,e1+1,e2+1);
      }
      fclose(fp1);

      strcpy(com,"./subdue -out ");
      sprintf(nnn,"%d",num_grafo);
      strcat(com,nnn);
      strcat(com,".sub ");
      if(directed == 'u')
        strcat(com," -undirected ");
      strcat(com," -maxsize 10 ");
      strcat(com,nnn);
      strcat(com," > /dev/null");
      system(com);
      strcat(nnn,".sub");
      f1 = fopen(nnn,"r+");
      fscanf(f1,"%s",str);
      bool = (int *)realloc(bool,sizeof(int)*(num_grafo+1));
      if(!strcmp(str,"S")) {
	cont_words++;
	bool[num_grafo] = 1;
	fseek(f1,0,0);
	fprintf(f1," ");
      }
      else
	bool[num_grafo] = 0;
      fclose(f1);
      num_grafo++;
    }
  }
  
  Mat = (int **)malloc(sizeof(int *)*num_grafo);
  for(i=0;i<num_grafo;i++)
    Mat[i] = (int *)malloc(sizeof(int)*cont_words);
  for(i=0;i<num_grafo;i++) {
    for(j=0;j<cont_words;j++) {
      Mat[i][j] = 0;
    }
  }

  k = 0;
  for(i=0;i<num_grafo;i++) {
    if(bool[i]==1) {
      sprintf(nnn,"%d",i);
      strcat(nnn,".sub");
      for(j=0;j<num_grafo;j++) {
	sprintf(nnn1,"%d",j);
	strcpy(com,"./sgiso ");
	strcat(com,nnn);
	strcat(com," ");
	strcat(com,nnn1);
	strcat(com," > output");
	system(com);
	f2 = fopen("output","r");
	num = 0;
	while(!feof(f2)) {
	  fscanf(f2,"%s",str);
	  if(!strcmp(str,"Found")) {
	    fscanf(f2,"%d",&num);
	    break;
	  }
	}
	Mat[j][k] = num;
	fclose(f2);
      }
      k++;
    }
  }

  for(i=0;i<num_grafo;i++) {
    sprintf(nnn,"%d",i);
    remove(nnn);
    strcat(nnn,".sub");
    remove(nnn);
  }

  f2 = fopen("MAPPA","w");
  for(i=0;i<num_grafo;i++) {
    for(j=0;j<cont_words;j++) {
      fprintf(f2,"%d ",Mat[i][j]);
    }
    fprintf(f2,"\n");
  }
  fclose(f2);

  fclose(fp);
  fprintf(stderr,"done\n");

  
  /* ----- PARSER ENDS ----- */
  /* It writes on 'MAPPA' the map, on 'words' all the patterns, on 'q' the converted query*/

  i=j=0;
  n = num_grafo;
  SpaceDim = cont_words;
  
  sscanf(argv[3],"%d",&range);

  if(range!=1 && range!=2 && range!=3 && range!=4) {
    fprintf(stderr,"\nThe range is 1..4!!!\n\n");
    exit(1);
  }

  //  fprintf(stderr,"\nSpaceDim:%d dim:%d d:%f",SpaceDim,n,d);

  if(!(fp = fopen("MAPPA","r+"))) {
    printf("file MAPPA not found. Exit...");
    exit(-1);
  }

  if(cont_words == 0) {
    fprintf(stderr,"\nNo substructures found!!!\n\n");
    exit(1);
  }

  fprintf(stderr,"Allocating Memory.....%d",cont_words);

  S = (Object *) malloc(n * sizeof(Object));
  if(!S)
    exit(-1);
  for(i = 0; i < n; i++) {
    S[i].X = (float *) malloc(sizeof(float)*SpaceDim);
    if(!S[i].X)
      exit(-1);
    S[i].index = (int *) malloc(sizeof(int));
    if(!S[i].index)
      exit(-1);
    S[i].idx_CLU = (int *) malloc(sizeof(int));
    if(!S[i].idx_CLU)
      exit(-1);
    S[i].Dv = NULL;
  }
  fprintf(stderr,"done\n");
  
  assert(fp);
  fprintf(stderr,"Loading Data.....");
  Load_Data2(S, n,SpaceDim,fp);
  fprintf(stderr,"done\n");
  fclose(fp);
  
  fprintf(stderr,"Making Clusters.....");
  Compute_Radius(range,S,n,&d);
  Tree = NULL;
  C_List = NULL;
  Tree = Build_Tree(S,n, 0, n-1, d,NULL,0,NULL);
  if(TOTAL > 1)
    fprintf(stderr,"done [%d Clusters]\n",TOTAL);
  else
    fprintf(stderr,"done [%d Cluster]\n",TOTAL);
  fprintf(stderr,"Writing file 'output'.....");
  num_clusters = 1;
  fp = fopen("output","w");
  write_output(Tree,name,&num_clusters,fp);
  fclose(fp);
  fprintf(stderr,"done\n");

  //  Visit_Tree(Tree);
  //visualizza(Tree);
  //getchar();
  
  Libera_Tree2(Tree);
  fprintf(stderr,"\n\n");

  for(i=0;i<10000;i++)
    free(name[i]);

  Libera_S(n);

  for(i=0;i<num_grafo;i++)
    free(Mat[i]);
  free(Mat);
  free(bool);

  return 1;
}
